package gov.va.med.fw.utils
{	
	import flash.utils.getQualifiedClassName;	
	import gov.va.med.fw.model.TermType;
	import gov.va.med.ccht.ui.common.model.IEquals;
	import mx.collections.ArrayCollection;
		
	/**
	 * <p>Assists in implementing IEquals.equals() methods.</p>
	 *
	 * <p>This class provides methods to build a good equals method for any class.</p>
	 *
	 * <p>All relevant fields should be included in the calculation of equals.</p>
	 *
	 * <p>Typical use for the code is as follows:</p>
	 * <pre>
	 * public function equals(object:Object):Boolean {
	 *   if (!object) { return false; }
	 *   if (object == this) { return true; }
	 *   if (!(object is MyClass)) {
	 *     return false;
	 *   }
	 *   MyClass that = MyClass(object);
	 *   return new EqualsBuilder()
	 *                 .append(field1, that.field1)
	 *                 .append(field2, that.field2)
	 *                 .append(field3, that.field3)
	 *                 .equals;
	 *  }
	 * </pre>
	 *
	 * @author Christophe Herreman
	 */
	public class EqualsBuilder {
		
		private var _equals:Boolean = true;
		
		/**
		 * Creates a new EqualsBuilder
		 */
		public function EqualsBuilder() {
		}
		
		/**
		 * Returns if the objects tested for equality by this equalsbuilder are equal.
		 *
		 * @return true if both objects are equal, false if not
		 */
		public function get equals():Boolean {
			return _equals;
		}
		
		/**
		 * Test if two <code>Object</code>s are equal.
		 *
		 * @param a the left hand object
		 * @param b the right hand object
		 * @return EqualsBuilder - used to chain calls.
		 */
		public function append(a:Object, b:Object):EqualsBuilder {
			if (equals == false || (a == null && b == null)) {
				return this;
			}
			
			if (a === b) {
				return this;
			}
			
			if (a == null || b == null) {
				_equals = false;
				return this;
			}
			
			if (getQualifiedClassName(a) != getQualifiedClassName(b)) {
				_equals = false;
				return this;
			}
			
			if (isSimple(a)) {
				if (a is TermType) {
					appendTermType(a as TermType, b as TermType);
				} else if (a is ArrayCollection) {
					appendArrayCollection(a as ArrayCollection, b as ArrayCollection);
				} else if (a is Date) {
					appendDate(a as Date, b as Date);
				} else if ((typeof(a) == "number") && (isNaN(Number(a)) && isNaN(Number(b)))) {
					return this;
				} else {
					_equals = false;
					return this;
				}
			} else if (a is IEquals) {
				appendEquals(IEquals(a), IEquals(b));
			} else if (a is XML) {
				appendXML(XML(a), XML(b));				
			} else {
				appendObject(a, b);
			}
			
			return this;
		}
		
		private function appendObject(a:Object, b:Object):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (getNumProperties(a) != getNumProperties(b)) {
				_equals = false;
				return this;
			}
			
			for (var key:* in a) {
				append(a[key], b[key]);
			}
			
			return this;
		}
		
		private function appendArrayCollection(a:ArrayCollection, b:ArrayCollection):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (a.length != b.length) {
				_equals = false;
				return this;
			}
						
			var numItems:uint = a.length;
			if (numItems == 0) 
				return this;
			
			//compare termtype collections
			if (a.getItemAt(0) is TermType) {
				if (!matchTermTypes(a,b)) {
					_equals = false;
				}
			} else {
				if (!matchObjects(a,b)) {
					_equals = false;
				}
			}
			return this;
		}
		private function appendTermType(a:TermType, b:TermType):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (a.value != b.value) {
				_equals = false;
			}
			
			return this;
		}
		
		private function appendDate(a:Date, b:Date):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (a.getTime() != b.getTime()) {
				_equals = false;
			}
			
			return this;
		}
		
		private function appendXML(a:XML, b:XML):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (a === b) {
				return this;
			}
			
			if (a.toXMLString() != b.toXMLString()) {
				_equals = false;
				return this;
			}
			
			return this;
		}

		private function appendEquals(a:IEquals, b:IEquals):EqualsBuilder {
			if (!_equals) {
				return this;
			}
			
			if (!a.equals(b)) {
				_equals = false;
			}
			
			return this;
		}
	
		private function isSimple(object:Object):Boolean {
			switch (typeof(object)) {
				case "number":
				case "string":
				case "boolean":
					return true;
				case "object":
					return (object is Date) || (object is TermType) || (object is ArrayCollection);
			}
			
			return false;
		}
		
		private function getNumProperties(object:Object):int {
			var result:int = 0;
			
			for (var p:String in object) {
				result++;
			}
			return result;
		}
		
		private function matchTermTypes(a:ArrayCollection, b:ArrayCollection):Boolean {
			var numItems:uint = a.length;
			for (var i:uint = 0; i < numItems; i++) {
				var tt1:TermType = a.getItemAt(i) as TermType; 
				var matchFound:Boolean = false;
				for (var j:uint = 0; j < numItems; j++) {
					var tt2:TermType = b.getItemAt(j) as TermType; 
					if (tt1.equals(tt2)) {
						matchFound = true;
						break;
					}
				}
				if (!matchFound) {
					return false;
				}
			}
			return true;
		}
		
		private function matchObjects(a:ArrayCollection, b:ArrayCollection):Boolean {
			var numItems:uint = a.length;
			for (var i:uint = 0; i < numItems; i++) {
				var tt1:Object = a.getItemAt(i) as Object; 
				var matchFound:Boolean = false;
				for (var j:uint = 0; j < numItems; j++) {
					var tt2:Object = b.getItemAt(j) as Object; 
					if (tt1 === tt2) {
						matchFound = true;
						break;
					}
				}
				if (!matchFound) {
					return false;
				}
			}
			return true;
		}
	}
}
