package gov.va.med.fw.rpc
{
	import flash.display.DisplayObject;
	import flash.utils.Dictionary;
	
	import gov.va.med.fw.controls.ProgressModalWindow;
	import gov.va.med.fw.utils.ExternalInterfaceDelegate;
	import mx.core.FlexGlobals;
	import mx.core.Application;
	import mx.core.IFlexDisplayObject;
	import mx.core.UIComponent;
	import mx.managers.PopUpManager;
	
	public class RemoteCallModelLocator
	{
		private static var popup:IFlexDisplayObject;
		private static var counters:Dictionary = new Dictionary();
		
		private static function incrementCounter(callName:String, multiple:Boolean=true):void
		{
			var _name:String = "counter_"+callName;
			if (!counters.hasOwnProperty(_name))
				counters[_name]=0;
			if(multiple || counters[_name]==0)
				counters[_name]++;
		}
		
		private static function decrementCounter(callName:String):void
		{
			var _name:String = "counter_"+callName;
			counters[_name]--;
		}
		
		private static function getCounters():int
		{
			var result:int=0;
			for (var prop:String in counters)
			{
				if (prop.indexOf("counter_")==0)
				{
					result = result + counters[prop];
				}
			}	
			return result;		
		}
		
		public static function setBusy(callName:String, multiple:Boolean=true):int
		{
			incrementCounter(callName, multiple);
			var trackedCalls:int = getCounters();
			if(trackedCalls>0 && popup==null)
			{
				showWindow();
			}
			return trackedCalls;	
		}
		
		public static function removeBusy(callName:String):int
		{
			decrementCounter(callName);
			var trackedCalls:int = getCounters();
			if(trackedCalls<=0 && popup!=null)
			{
				hideWindow();
			}	
			return trackedCalls;
		}
		
		public static function reset():void
		{
			for each(var prop:String in counters)
			{
				if (prop.indexOf("counter_")==0)
				{
					counters[prop]=0;
				}
			}	
			hideWindow();
		}
		
		private static function showWindow():void 
		{
				popup = new ProgressModalWindow();
				popup.x = (FlexGlobals.topLevelApplication.width/2) - (popup.width/2);
				//popup.y = (FlexGlobals.topLevelApplication.height/2) - (popup.height/2);
				PopUpManager.addPopUp(popup, FlexGlobals.topLevelApplication as DisplayObject, true);
				(popup as UIComponent).validateNow();
				PopUpManager.bringToFront(popup);
				ExternalInterfaceDelegate.call("setFocus");
				ExternalInterfaceDelegate.call("setFocusToOhrsMovie");
        }
       
        private static function hideWindow():void 
		{
			if(popup!=null)
			{
				PopUpManager.removePopUp(popup);
				popup=null;
			}
       }

	}
}
