package gov.va.med.fw.model {
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.fw.ui.model.TreeItem")]
	public class TreeItem {
		
		public var label:String;
		public var value:String;
		public var enabled:Boolean = true;
		public var children:ArrayCollection = null;
		public var parent:TreeItem;
		
		public function TreeItem() {}
		public function addChild(child:TreeItem, index:int):void {
			if (children == null) {
				children = new ArrayCollection();
			}
			if (index > -1) {
				children.addItemAt(child,index);
			}else {
				children.addItem(child);
			}
			//set the parent node
			child.parent = this;			
		}
		
		public function removeChild(child:TreeItem, index:int):void {
			if (children != null) {
				if (index > -1) {				
					children.removeItemAt(index);
				}else {
					//find the child and remove
					for (var i:int=0; i<children.length; i++) {
						var childItem:TreeItem = children[i] as TreeItem;
						if (child.value == childItem.value) {
							//remove the item and return
							children.removeItemAt(i);
							return;
						}						
					}				
				}
			}
		}	
	}
}