package gov.va.med.fw.controls {
	
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.ui.Keyboard;
	
	import gov.va.med.fw.events.MessageLinkEvent;
	
	import mx.core.UIComponent;
	import mx.managers.IFocusManagerComponent;
	
	
	[Event(name="setFocus", type="gov.va.med.ohrs.ui.framework.command.MessageLinkEvent")]

	public class TextLink extends Text {
		
		[Bindable]
		public var linkField:UIComponent = null;
	
		public function TextLink() {
			super();
			//this.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
        	this.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
        	this.addEventListener(MouseEvent.CLICK, clickHandler);
		}

		
		override protected function keyDownHandler(event:KeyboardEvent):void {
	       	super.keyDownHandler(event);
	       	if(event.keyCode == Keyboard.ENTER || event.keyCode == Keyboard.SPACE) {
	        	setFocusToLinkField();
	        }
	    }

	    override protected function keyUpHandler(event:KeyboardEvent):void {
	        super.keyUpHandler(event);
	        if(event.keyCode == Keyboard.ENTER || event.keyCode == Keyboard.SPACE) {
	        	setFocusToLinkField();
	        }
	    }

	    protected function clickHandler(event:MouseEvent):void {
	    	//super.clickHandler(event);
	    	setFocusToLinkField();
	    }
	    
	    private function setFocusToLinkField():void {
	    	if(linkField != null && linkField is IFocusManagerComponent) {
	    		//focusManager.setFocus(linkField is IFocusManagerComponent);
	    		linkField.setFocus();
	    		dispatchEvent(new MessageLinkEvent(MessageLinkEvent.SET_FOCUS,linkField));
	    	}
	    }
	}
}