package gov.va.med.fw.controls {
	
	import flash.accessibility.AccessibilityProperties;
	import flash.display.DisplayObject;
	import flash.events.FocusEvent;
	
	import gov.va.med.fw.utils.AccessibilityDelegate;
	
	import mx.controls.Text;
	import mx.core.mx_internal;
	import mx.managers.IFocusManagerComponent;
	
	use namespace mx_internal;
	
	[AccessibilityClass(implementation="mx.accessibility.LinkButtonAccImpl")]
	
	public class Text extends mx.controls.Text implements IFocusManagerComponent {
		
		mx_internal static var createAccessibilityImplementation:Function;
		
		public function Text() {
			super();
			tabChildren = true; 
			tabEnabled = true;
			selectable = true;
			this.addEventListener(FocusEvent.FOCUS_IN, onFocus); 

			this.accessibilityProperties = new AccessibilityProperties();
			accessibilityProperties.name = this.text;
			accessibilityProperties.description = this.text;
           	AccessibilityDelegate.updateProperties();
		}
		
		public function onFocus(event:FocusEvent):void {
	        AccessibilityDelegate.sendEvent(DisplayObject(this.textField),0,0x8005,true);
	        AccessibilityDelegate.updateProperties();
		}
		
		override protected function initializeAccessibility():void {
			if (createAccessibilityImplementation != null)
				createAccessibilityImplementation(this);
		}
	}
}