package gov.va.med.fw.controls {
	
	import flash.accessibility.AccessibilityProperties;
	import flash.display.DisplayObject;
	import flash.events.FocusEvent;
	
	import gov.va.med.fw.utils.AccessibilityDelegate;
	import gov.va.med.fw.utils.StringUtils;
	
	import mx.controls.Label;
	import mx.core.mx_internal;
	import mx.managers.IFocusManagerComponent;
	import mx.resources.ResourceManager;
	
	use namespace mx_internal;
	
	[AccessibilityClass(implementation="mx.accessibility.LinkButtonAccImpl")]
	
	public class Label extends mx.controls.Label implements IFocusManagerComponent {
		
		mx_internal static var createAccessibilityImplementation:Function;
		
		public var key:String = "";
		public var append:String = "";
		public var bundle:String = "";
			
		public function Label() {
			super();
			tabChildren = true; 
			tabEnabled = true;
			selectable = true;
			
			this.addEventListener(FocusEvent.FOCUS_IN, onFocus); 
			this.accessibilityProperties = new AccessibilityProperties();
			accessibilityProperties.name = this.text;
			accessibilityProperties.description = this.text;
           	AccessibilityDelegate.updateProperties();
		}
				
			
		/**
		 *  If the label attribute is not given, uses bundle and key attributes to get 
		 *  the text value. If the append attribute is present is provided appends 
		 *  it to the label value.
		 */ 
		override public function get text():String {
			var string:String = super.text;
			if(StringUtils.isNotEmpty(string)) {
				if(StringUtils.isNotEmpty(append)) {
					if(string.charAt(string.length-1) != ':') {
						super.text = string = string.concat(append);
					}
				}
			} else if(StringUtils.isNotEmpty(key) && StringUtils.isNotEmpty(bundle)) {
				string = ResourceManager.getInstance().getString(bundle,key);
				super.text = string = (StringUtils.isNull(string)) ? append : string.concat(append);
			}
			return string;
		}
		
		override public function set text(value:String):void {
			super.text = value;
			this.accessibilityProperties = new AccessibilityProperties();
			accessibilityProperties.name = value;
			accessibilityProperties.description = value;
           	AccessibilityDelegate.updateProperties();
		}
		
		public function onFocus(event:FocusEvent):void {
	        AccessibilityDelegate.sendEvent(DisplayObject(this.textField),0,0x8005,true);
	        AccessibilityDelegate.updateProperties();
		}
		
		override protected function initializeAccessibility():void {
			if (createAccessibilityImplementation != null)
				createAccessibilityImplementation(this);
		}
	}
}
