package gov.va.med.ccht.ui.dmp.command
{
	import mx.collections.ArrayCollection;
	import gov.va.med.ccht.ui.dmp.model.DMP;
	import gov.va.med.fw.model.TermType;

	public class TestData
	{
		private static var testData : TestData;
		private var dmpStatusList:ArrayCollection = null;
		private var myDMPList:ArrayCollection = null;
		
		public static function getInstance() : TestData {
			
			if(testData == null) {
				testData = new TestData();
			}
			return testData;
		}
		
		public function TestData()
		{
			if(testData != null) {
				throw new Error( "Only one TestData instance should be instantiated" );	
			}
		}
		
		public function getMyDMPs() : ArrayCollection {
			if( myDMPList == null ) {
				myDMPList = new ArrayCollection();
			}
			return myDMPList;
		}
		
		public function submitDMP(dmp:DMP) : void {
			this.getMyDMPs().addItem(dmp);
		}
	}
}