package gov.va.med.ccht.ui.common.view
{
	import flash.display.DisplayObject;
	import flash.events.ContextMenuEvent;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	import flash.utils.getQualifiedClassName;
	
	import gov.va.med.ccht.ui.common.command.AppConstants;
	import gov.va.med.ccht.ui.common.utils.TermsCache;
	import gov.va.med.fw.controls.AccessibleDataGrid;
	import gov.va.med.fw.controls.Button;
	import gov.va.med.fw.controls.ComboBox;
	import gov.va.med.fw.controls.IFooterDataGrid;
	import gov.va.med.fw.controls.Label;
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils._508Util;
	
	import mx.binding.utils.BindingUtils;
	import mx.collections.ArrayCollection;
	import mx.containers.HBox;
	//import mx.accessibility.P
	import mx.containers.Panel;
	//import spark.accessibility.
	import mx.controls.AdvancedDataGrid;
	import mx.core.Container;
	import mx.core.UIComponent;
	import mx.core.UITextField;
	import mx.core.mx_internal;
	import mx.events.ListEvent;
	import mx.managers.CursorManager;
	import mx.resources.ResourceManager;
	import mx.styles.CSSStyleDeclaration;
	import mx.styles.IStyleManager2;
	import mx.styles.StyleManager;
	

				
	[Event(name="resizeStart", type="flexmdi.events.DataGridPanelEvent")]
	[Event(name="resize", type="flexmdi.events.DataGridPanelEvent")]
	[Event(name="resizeEnd", type="flexmdi.events.DataGridPanelEvent")]

	public class DataGridPanel extends Panel
	{									
		private var _controlContainer:HBox;
		private var _labelShowRows:Label;
		private var _dataGridController:ComboBox;	
		private var _beginButton:Button;
		private var _previousButton:Button;
		private var _nextButton:Button;
		private var _endButton:Button;
		private var _rowCountIncrement:int = 0;
		
		[Bindable] private var _dataGrid:IFooterDataGrid;
		
		public var _variablePageSize:Boolean = true;
								
		public var resizable:Boolean = true;
		private var resizeHandleRight:Button;
		private var resizeHandleLeft:Button;
		private var currentResizeHandle:Button;
		public var savedWindowRect:Rectangle;
		
		private var _resizing:Boolean;
		private var dragStartMouseX:Number;
		private var dragStartMouseY:Number;
		private var dragMaxX:Number;
		private var dragMaxY:Number;
		private var dragAmountX:Number;
		private var dragAmountY:Number;
		private var _windowStyleName:Object;
				
		[Embed(source="/flexmdi/assets/img/resizeCursorH.gif")]
		private static var DEFAULT_RESIZE_CURSOR_HORIZONTAL:Class;
		private static var DEFAULT_RESIZE_CURSOR_HORIZONTAL_X_OFFSET:Number = -10;
		private static var DEFAULT_RESIZE_CURSOR_HORIZONTAL_Y_OFFSET:Number = -10;
		private static var DEFAULT_RESIZE_HORIZONTAL_PADDING_OFFSET:Number = 10;
		
		private static var edgeHandleSize:Number = 4;
		private static var cornerHandleSize:Number = 10;
		private static var labelWidth:Number = 100;
		private static var dgControllerWidth:Number = 80;
		private static var buttonWidth:Number = 40;
		private static var hortozontalSpacing:Number = 10;
		private static var topMargin:Number = 4;
		private static var bottomMarging:Number = 2;
		
		private static var classConstructed:Boolean = classConstruct();
		
		/**
		 * Define and prepare default styles.
		 */
		private static function classConstruct():Boolean
		{			
			var selector:CSSStyleDeclaration = StyleManager.getStyleManager(null).getMergedStyleDeclaration("dataGridPanel");
			if(!selector)
			{
				selector = new CSSStyleDeclaration();
			}
			// these are default names for secondary styles. these can be set in CSS and will affect
			// all windows that don't have an override for these styles.
			selector.defaultFactory = function():void
			{						
				this.resizeCursorHorizontalSkin = DEFAULT_RESIZE_CURSOR_HORIZONTAL;
				this.resizeCursorHorizontalXOffset = DEFAULT_RESIZE_CURSOR_HORIZONTAL_X_OFFSET;
				this.resizeCursorHorizontalYOffset = DEFAULT_RESIZE_CURSOR_HORIZONTAL_Y_OFFSET;
				
			}
			//apply
			StyleManager.getStyleManager(null).setStyleDeclaration("dataGridPanel", selector, false);
			
			return true;
		}
		
		/**
		 * Constructor
		 */
		public function DataGridPanel()
		{
			super();
			minWidth = 400;
			minHeight = 200;
			doubleClickEnabled = true;		
			accessibilityName = "Datagrid Control Panel";
			tabChildren = true; 
			tabEnabled = true;
		}
		private function setPageSize(pageSize:int):void {
			if (pageSize && pageSize > 0) {
				var term:TermType = TermType.create(pageSize.toString(),pageSize.toString());
				_dataGridController.selectedItem = term;
			}
		}
		private function showRows(event:ListEvent):void {
			var rowSize:TermType = event.currentTarget.selectedItem as TermType;
			if (rowSize != null && _dataGrid != null && _dataGrid.dataProvider != null) {
				var rowCount:int  = int(rowSize.value);
				var list:ArrayCollection = _dataGrid.dataProvider as ArrayCollection;
				if (list != null && list.length > 0) {
					//if total rows are less reduce the rowcount
					if (list.length < rowCount)
						rowCount = _dataGrid.rowCount = list.length;					
					
					//set grid size
					if (_dataGrid.variableRowHeight) {
						//_dataGrid.rowHeight*(_rowCount + 2);
					}else {
						_dataGrid.rowCount = rowCount + _rowCountIncrement;
					}
				}
			}
			
		}
		public function set variablePageSize(value:Boolean):void {
			_variablePageSize = value;
			if (_dataGridController) {
				_dataGridController.enabled = _variablePageSize;
			}
		}
		public function get variablePageSize():Boolean {
			return _variablePageSize;
		}
		public function set dataGrid(dg:IFooterDataGrid):void {
			_dataGrid = dg; 
			if (_dataGrid != null && _dataGrid is AdvancedDataGrid) {
				_rowCountIncrement = 1;
			}
		}
		
		public function get windowStyleName():Object
		{
			return _windowStyleName;
		}
		
		public function set windowStyleName(value:Object):void
		{
			if(_windowStyleName === value)
				return;
			
			_windowStyleName = value;
			updateStyles();
		}
		
		/**
		 * Create resize handles and window controls.
		 */
		override protected function createChildren():void
		{
			super.createChildren();
			if(!resizeHandleRight)
			{
				resizeHandleRight = new Button();
				resizeHandleRight.y = cornerHandleSize * .5;
				resizeHandleRight.width = edgeHandleSize;
				resizeHandleRight.alpha = 0;
				resizeHandleRight.focusEnabled = false;
				//resizeHandleRight.accessibilityName ="Resize Handle Right";
				rawChildren.addChild(resizeHandleRight);
			}
			
			if(!resizeHandleLeft)
			{
				resizeHandleLeft = new Button();
				resizeHandleLeft.y = cornerHandleSize * .5;
				resizeHandleLeft.width = edgeHandleSize;
				resizeHandleLeft.alpha = 0;
				resizeHandleLeft.focusEnabled = false;
				//resizeHandleRight.accessibilityName ="Resize Handle Left";
				rawChildren.addChild(resizeHandleLeft);
			}
			if (!_controlContainer) {
				_controlContainer = new HBox();
				_controlContainer.accessibilityEnabled=true;
				_controlContainer.tabChildren=false;
			}
			if (!_labelShowRows) {
				_labelShowRows = new Label();				
				_labelShowRows.text = "Show Rows:"
				_labelShowRows.styleName = "formItemLabel";
				_controlContainer.addChild(_labelShowRows);
			}
			
			if (!_dataGridController) {
				_dataGridController = new ComboBox();	
				_dataGridController.name="selection test box";
				_dataGridController.accessibilityEnabled=true;
				_dataGridController.dataProvider = TermsCache.getInstance().getDataGridRowCountTypes();
				//_dataGridController.selectedIndex = -1;
				_dataGridController.prompt="Select";
				_dataGridController.toolTip="Show Rows Selection Box";
				//_dataGridController.focusRect = false;
				_dataGridController.accessibilityName ="Show Rows Selection Box";
				_controlContainer.addChild(_dataGridController);
				_dataGridController.enabled = _variablePageSize;
			}
			if (!_beginButton) {
				_beginButton = new Button();
				_beginButton.name="First Page";
				_beginButton.label="First Page";
				_beginButton.accessibilityEnabled=true;
				_beginButton.label = "|<";
				_beginButton.toolTip="First Page";
				_beginButton.accessibilityName = "First Page";
				_beginButton.width = buttonWidth;
				_controlContainer.addChild(_beginButton);
			}
			if (!_previousButton) {
				_previousButton = new Button();
				_previousButton.label = "<<";
				_previousButton.accessibilityName = "Previous Page";
				_previousButton.width = buttonWidth;
				_controlContainer.addChild(_previousButton);
			}
			if (!_nextButton) {
				_nextButton = new Button();
				_nextButton.label = ">>";
				_nextButton.accessibilityName = "Next Page";
				_nextButton.width = buttonWidth;
				_controlContainer.addChild(_nextButton);
			}
			if (!_endButton) {
				_endButton = new Button();
				_endButton.label = ">|";
				_endButton.accessibilityName = "Last Page";
				_endButton.width = buttonWidth;
				_controlContainer.addChild(_endButton);
			}
			titleBar.accessibilityEnabled=true;
		    titleBar.tabChildren=true;
			titleBar.accessibilityName="List title bar";
			titleBar.addChild(_controlContainer);
			addListeners();
		}
		
		/**
		 * Position and size resize handles and window controls.
		 */
		override protected function updateDisplayList(w:Number, h:Number):void
		{
			super.updateDisplayList(w, h);
			
			resizeHandleRight.x = this.width - edgeHandleSize * .5;
			resizeHandleRight.y = cornerHandleSize * .5;
			resizeHandleRight.width = edgeHandleSize;
			resizeHandleRight.height = this.height - cornerHandleSize;
			
			resizeHandleLeft.x = -(edgeHandleSize * .5);
			resizeHandleLeft.y = cornerHandleSize * .5;
			resizeHandleLeft.width = edgeHandleSize;
			resizeHandleLeft.height = this.height - cornerHandleSize;
			
			//measure the size 
			_controlContainer.setActualSize( _controlContainer.getExplicitOrMeasuredWidth(),
			_controlContainer.getExplicitOrMeasuredHeight() );
			
			// Position the HBox 			
			var y:int = 1+ ((titleBar.height - _controlContainer.height)/2)
			var x:int = hortozontalSpacing;
			_controlContainer.move(x, y);
		}
				
		/**
		 * Mother of all styling functions. All styles fall back to the defaults if necessary.
		 */
		private function updateStyles():void
		{
			var selectorList:Array = getSelectorList();	
		}
		
		protected function getSelectorList():Array
		{
			// initialize array with ref to ourself since inline styles take highest priority
			var selectorList:Array = new Array(this);
			
			// if windowStyleName was set by developer we associated styles to the list
			if(windowStyleName)
			{
				// make sure a corresponding style actually exists
				var classSelector:CSSStyleDeclaration = StyleManager.getStyleManager(null).getMergedStyleDeclaration("." + windowStyleName);
				if(classSelector)
				{
					selectorList.push(classSelector);
				}
			}
			// add type selector (created in classConstruct so we know it exists)
			var typeSelector:CSSStyleDeclaration = StyleManager.getStyleManager(null).getMergedStyleDeclaration("dataGridPanel");
			selectorList.push(typeSelector);
			
			return selectorList;
		}
		
		/**
		 * Function to return appropriate style based on our funky setup.
		 * Precedence of styles is inline, class selector (as specified by windowStyleName)
		 * and then type selector (DataGridPanel).
		 * 
		 * @private
		 */
		protected function getStyleByPriority(selectorList:Array, style:String):Object
		{			
			var n:int = selectorList.length;			
			
			for(var i:int = 0; i < n; i++)
			{
				// we need to make sure this.getStyle() is not pointing to the style defined
				// in the type selector because styles defined in the class selector (windowStyleName)
				// should take precedence over type selector (DataGridPanel) styles
				// this.getStyle() will return styles from the type selector if an inline
				// style was not specified
				if(selectorList[i] == this 
					&& selectorList[i].getStyle(style) 
					&& this.getStyle(style) === selectorList[n - 1].getStyle(style))
				{
					continue;
				}
				if(selectorList[i].getStyle(style))
				{
					// if this is a style name make sure the style exists
					if(typeof(selectorList[i].getStyle(style)) == "string"
						&& !(StyleManager.getStyleManager(null).getMergedStyleDeclaration("." + selectorList[i].getStyle(style))))
					{
						continue;
					}
					else
					{
						return selectorList[i].getStyle(style);
					}
				}
			}
			
			return null;
		}
										
		/**
		 * Add listeners for resize handles and window controls.
		 */
		private function addListeners():void
		{
			resizeHandleRight.addEventListener(MouseEvent.ROLL_OVER, onResizeButtonRollOver, false, 0, true);
			resizeHandleRight.addEventListener(MouseEvent.ROLL_OUT, onResizeButtonRollOut, false, 0, true);
			resizeHandleRight.addEventListener(MouseEvent.MOUSE_DOWN, onResizeButtonPress, false, 0, true);
			resizeHandleLeft.addEventListener(MouseEvent.ROLL_OVER, onResizeButtonRollOver, false, 0, true);
			resizeHandleLeft.addEventListener(MouseEvent.ROLL_OUT, onResizeButtonRollOut, false, 0, true);
			resizeHandleLeft.addEventListener(MouseEvent.MOUSE_DOWN, onResizeButtonPress, false, 0, true);
	
			_dataGridController.addEventListener(ListEvent.CHANGE, showRows, false, 0, true);
			_beginButton.addEventListener(MouseEvent.CLICK, scrollToFirstPage, false, 0, true);
			_previousButton.addEventListener(MouseEvent.CLICK, scrollToPreviousPage, false, 0, true);
			_nextButton.addEventListener(MouseEvent.CLICK, scrollToNextPage, false, 0, true);
			_endButton.addEventListener(MouseEvent.CLICK, scrollToLastPage, false, 0, true);			
		}
		private function scrollToFirstPage(event:Event):void {
			scroll(AppConstants.FIRST_PAGE);
		}
		private function scrollToPreviousPage(event:Event):void {
			scroll(AppConstants.PREVIOUS_PAGE);
		}
		private function scrollToNextPage(event:Event):void {
			scroll(AppConstants.NEXT_PAGE);
		}
		private function scrollToLastPage(event:Event):void {
			scroll(AppConstants.LAST_PAGE);
		}
		private function scroll(scrollType:int):void {
			if (_dataGrid) {
				_dataGrid.scroll(scrollType);
			}
		}

	
		/**
		 * Save the panel's floating coordinates.
		 * 
		 * @private
		 */
		private function savePanel():void
		{
			savedWindowRect = new Rectangle(this.x, this.y, this.width, this.height);
		}
		
		/**
		 * Mouse down on any resize handle.
		 */
		private function onResizeButtonPress(event:MouseEvent):void
		{
			currentResizeHandle = event.target as Button;
			setCursor(currentResizeHandle);
			dragStartMouseX = parent.mouseX;
			dragStartMouseY = parent.mouseY;
			savePanel();
			
			dragMaxX = savedWindowRect.x + (savedWindowRect.width - minWidth);
			dragMaxY = savedWindowRect.y + (savedWindowRect.height - minHeight);
			
			systemManager.addEventListener(Event.ENTER_FRAME, updateWindowSize, false, 0, true);
			systemManager.addEventListener(MouseEvent.MOUSE_MOVE, onResizeButtonDrag, false, 0, true);
			systemManager.addEventListener(MouseEvent.MOUSE_UP, onResizeButtonRelease, false, 0, true);
			systemManager.stage.addEventListener(Event.MOUSE_LEAVE, onMouseLeaveStage, false, 0, true);
		}
		
		private function onResizeButtonDrag(event:MouseEvent):void
		{
			if(!_resizing)
			{
				_resizing = true;
				dispatchEvent(new DataGridPanelEvent(DataGridPanelEvent.RESIZE_START, this));
			}			
			dispatchEvent(new DataGridPanelEvent(DataGridPanelEvent.RESIZE, this));
		}
		
		/**
		 * Mouse move while mouse is down on a resize handle
		 */
		private function updateWindowSize(event:Event):void
		{
			dragAmountX = parent.mouseX - dragStartMouseX;
			dragAmountY = parent.mouseY - dragStartMouseY;
			
			if(currentResizeHandle == resizeHandleRight && 
				parent.mouseX < (parent.width-DEFAULT_RESIZE_HORIZONTAL_PADDING_OFFSET))
			{
				this.width = Math.max(savedWindowRect.width + dragAmountX, minWidth);
			}
			else if(currentResizeHandle == resizeHandleLeft 
				&& parent.mouseX > DEFAULT_RESIZE_HORIZONTAL_PADDING_OFFSET)
			{
				this.width = Math.max(savedWindowRect.width - dragAmountX, minWidth);
			}
		}
		
		private function onResizeButtonRelease(event:MouseEvent = null):void
		{
			if(_resizing)
			{
				_resizing = false;
				dispatchEvent(new DataGridPanelEvent(DataGridPanelEvent.RESIZE_END, this));
			}
			currentResizeHandle = null;
			systemManager.removeEventListener(Event.ENTER_FRAME, updateWindowSize);
			systemManager.removeEventListener(MouseEvent.MOUSE_MOVE, onResizeButtonDrag);
			systemManager.removeEventListener(MouseEvent.MOUSE_UP, onResizeButtonRelease);
			systemManager.stage.removeEventListener(Event.MOUSE_LEAVE, onMouseLeaveStage);
			CursorManager.removeCursor(CursorManager.currentCursorID);
		}
		
		private function onMouseLeaveStage(event:Event):void
		{
			onResizeButtonRelease();
			systemManager.stage.removeEventListener(Event.MOUSE_LEAVE, onMouseLeaveStage);
		}
						
		private function setCursor(target:Button):void
		{
			var styleStub:String;			
			
			switch(target)
			{
				case resizeHandleLeft:
				case resizeHandleRight:
					styleStub = "resizeCursorHorizontal";
					break;
			}
			
			var selectorList:Array = getSelectorList();
			
			CursorManager.removeCursor(CursorManager.currentCursorID);
			CursorManager.setCursor(
				Class(getStyleByPriority(selectorList, styleStub + "Skin")), 
				2, 
				Number(getStyleByPriority(selectorList, styleStub + "XOffset")), 
				Number(getStyleByPriority(selectorList, styleStub + "YOffset"))
				);
		}
		
		private function onResizeButtonRollOver(event:MouseEvent):void
		{
			if(!event.buttonDown)
			{
				setCursor(event.target as Button);
			}
		}
		
		private function onResizeButtonRollOut(event:MouseEvent):void
		{
			if(!event.buttonDown)
			{
				CursorManager.removeCursor(CursorManager.currentCursorID);
			}
		}	
		
		public function getAccessibleChildren():Array {
			//controls
			var arr:Array = new Array();
			if(_labelShowRows) arr.push(_labelShowRows);
			if(_dataGridController) arr.push(_dataGridController);	
			if( _beginButton) arr.push(_beginButton);
			if( _previousButton) arr.push(_previousButton);
			if( _nextButton) arr.push(_nextButton);
			if( _endButton) arr.push(_endButton);
			return arr;
		}		
	}

}