package gov.va.med.ccht.ui.common.view
{	
	import flash.accessibility.Accessibility;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.KeyboardEvent;
	import flash.net.*;
	import flash.ui.Keyboard;
	
	import flexmdi.containers.*;
	
	import gov.va.med.ccht.ui.common.command.AppConstants;
	import gov.va.med.ccht.ui.common.command.ClientSession;
	import gov.va.med.ccht.ui.common.command.NavigationEvent;
	import gov.va.med.ccht.ui.common.command.RemoteCallResult;
	import gov.va.med.ccht.ui.common.utils.UIUtils;
	import gov.va.med.ccht.ui.common.model.Report;
	import gov.va.med.ccht.ui.common.model.UserPrincipal;
	import gov.va.med.fw.utils.AccessibilityDelegate;
	import gov.va.med.fw.utils.EventDispatcherProxy;
	import gov.va.med.fw.utils.ExternalInterfaceDelegate;
	import gov.va.med.fw.utils.SortUtils;
	import gov.va.med.fw.utils.FormatUtils;
	
	import mx.collections.ArrayCollection;
	import mx.controls.AdvancedDataGrid;
	import mx.controls.Alert;
	import mx.controls.advancedDataGridClasses.AdvancedDataGridHeaderRenderer;
	import mx.core.Application;
	import mx.core.Container;
	import mx.core.FlexGlobals;
	import mx.core.UIComponent;
	import mx.events.FlexEvent;
	import mx.events.StateChangeEvent;
	import mx.formatters.DateFormatter;
	import mx.managers.PopUpManager;
	import mx.resources.ResourceManager;
	import mx.controls.dataGridClasses.DataGridColumn;
	
	import spark.components.VGroup;
						
	public class BaseWindow extends MDIWindow
	{			
		protected static const CREATE:String = "Create";
		protected static const READ:String = "Read";
		protected static const UPDATE:String = "Update";
		protected static const DELETE:String = "Delete";
		protected static const UNLOCK:String = "Unlock";
					
		private var _edp:EventDispatcherProxy = new EventDispatcherProxy(this as EventDispatcher);
		
		protected function setUp():void
		{
			addEventListener(flash.events.Event.REMOVED_FROM_STAGE, cleanUp, false, 0, true); 
		}
		
		protected function cleanUp(evt:*):void
		{
			removeEventListener(flash.events.Event.REMOVED_FROM_STAGE, cleanUp, false);
			_edp.removeAllEventListenes();
		}
					
		public function addEventListenerSafe(type:String, listener:Function, listenerName:String, useCapture:Boolean=false, priority:int=0, useWeakReference:Boolean=false):void
		{
			_edp.addEventListener(type, listener, listenerName, useCapture, priority, useWeakReference);
		}
		
		public function removeEventListenerSafe(type:String, listener:Function, listenerName:String, useCapture:Boolean=false):void
		{
			_edp.removeEventListener(type, listener, listenerName, useCapture);
		}
		public function returnToHome(event:Event):void {
			close();		
		}
			
		public function reset():void {            	
        }
        			
		public function handleEvent(functionName:Function, event:Event):void {
			try {
				functionName(event);
			} catch(error:Error) {
				this.handleFlexError(error);
			}
		}
		
   		
		public function navigateToExternalSource(url:String):void {
			if(url != null && url.length > 0) {
				var urlRequest:URLRequest = new URLRequest(url);
				navigateToURL(urlRequest,"ccht_page");
			}
		}
		
		public function navigateToExternalSourceByKey(event:KeyboardEvent,url:String):void {
			if(event.keyCode == Keyboard.ENTER || event.keyCode == Keyboard.SPACE) { 
				navigateToExternalSource(url);
			}
		}
		
		public function toUrl(bundle:String, urlKey:String):void {
    		var url:String = getMessage(bundle,urlKey);
    		navigateToExternalSource(url);
		}
	
		public function toUrlByKey(event:KeyboardEvent, bundle:String, urlKey:String):void {
			var url:String = getMessage(bundle,urlKey);
			navigateToExternalSourceByKey(event,url);
		}
		
		public function getCurrentDate():String {
			var df:DateFormatter = new DateFormatter();
			df.formatString="MM/DD/YYYY";
			return df.format(new Date());
		}

		public function getCurrentTime():String {
			var df:DateFormatter = new DateFormatter();
			df.formatString="JJ:NN";
			return df.format(new Date());
		}
		
		public function getFromBundle(bundleName:String,resourceName:String):String {
			return resourceManager.getString(bundleName,resourceName);
		}        
		
		public function handleStateChangeEvent(event:StateChangeEvent):void {
			updateAccessibilityProperties(name,event.newState);
		}
		
		protected function updateAccessibilityProperties(componentName:String, componentState:String):void {
			if (Accessibility.active)
			{
				var propName:String = componentName + "." + componentState + ".name";
				var propDesc:String = componentName + "." + componentState + ".description";
				accessibilityName = getMessage("common",propName);
				accessibilityDescription = getMessage("common",propDesc);									
				Accessibility.updateProperties();
			}
		}
				
		protected function getLoginUser():UserPrincipal {
			return ClientSession.getLoginUser();
		}

		public function isAuthorized(permission:String) : Boolean {
			return ClientSession.isAuthorized(permission);	
		}

		public static function isAuthorizedAny(permissions:ArrayCollection) : Boolean {
			return ClientSession.isAuthorizedAny(permissions);
		}
		
		public function handleCchtEvent(key:String, identifier:Object=null):void  {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.eventHandler(key, identifier as NavigationEvent);
			}
		}

		public function applicationError(error:Object):void {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.handleAppError(error);
			}
		}
		
		public function handleFlexError(error:Error):void {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.handleFlexError(error);
			}
		}
					
		public function displayPopup(parent:UIComponent,pop:Container, x:Number = -1,y:Number = -1): void {
			popup(parent,pop,x,y);
		}
		
		public static function popup(parent:UIComponent,popup:Container, x:Number = -1,y:Number = -1, modal:Boolean = true): void {
			popup.x = (x == -1) ? (FlexGlobals.topLevelApplication.width/2) - Math.max(popup.width/2, popup.minWidth/2) : x;
			popup.y = (y == -1) ? AppConstants.POPUP_WINDOW_POSITION_Y : y; 
			PopUpManager.addPopUp(popup, parent, modal);
			PopUpManager.bringToFront(popup);
		}
		
		public function displayAlert(parent:UIComponent,alert:Alert, x:Number = -1,y:Number = -1): void {
			x = (x == -1) ? (FlexGlobals.topLevelApplication.width/2) - (alert.width/2) : x;
			y = (y == -1) ? AppConstants.POPUP_WINDOW_POSITION_Y : x;
			alert.validateNow();
			alert.move(x,y); 
		}
		
		public function showAlert(text:String = "", title:String = "", flags:uint = 0x4, parent:Sprite = null, closeHandler:Function = null, iconClass:Class = null, defaultButtonFlag:uint = 0x4, x:Number = -1, y:Number = -1):void {
			UIUtils.alert(text, title, flags, parent, closeHandler, iconClass, defaultButtonFlag,x,y);
		}
		
		public function setErrorBorder(c:Container, isError:Boolean):void {
			if (c!= null) {
				if (isError) {
					UIUtils.markBoxAsInvalid(c);
				} else {
					UIUtils.markBoxAsValid(c);
				}
			}
		}			
		
		public static function displayOptimisticLockError(parent:UIComponent, callResult:RemoteCallResult): void {
			if(callResult != null && callResult.callStatus != null) {
				var errorType:String = callResult.callStatus;
				var optError:OptimisticLockError = new OptimisticLockError(); 
				optError.errorType = errorType;
				popup(parent,optError);					
			}
		}
		
		public function sortVisn(obj1:Object, obj2:Object):int {
			return SortUtils.sortVisn(obj1, obj2);
		}
		public function formatDate(item:Object, column:DataGridColumn):String
		{
			try
			{					
				return FormatUtils.formatDate(item[column.dataField] as Date);
			}catch (e:Error) {}
			return "";		
		}
	}
}

