package gov.va.med.ccht.ui.common.view
{
	import flash.display.Sprite;
	import flash.sampler.NewObjectSample;
	
	import gov.va.med.ccht.ui.common.command.AppConstants;
	import gov.va.med.ccht.ui.common.command.ClientSession;
	import gov.va.med.ccht.ui.common.command.NavigationEvent;
	import gov.va.med.ccht.ui.common.command.RemoteCallResult;
	import gov.va.med.ccht.ui.common.utils.UIUtils;
	import gov.va.med.ccht.ui.common.model.UserPrincipal;
	import gov.va.med.fw.utils.AccessibilityDelegate;
	import gov.va.med.fw.utils.EventDispatcherProxy;
	import gov.va.med.fw.utils.ExternalInterfaceDelegate;
	import gov.va.med.fw.utils.SortUtils;
	
	import mx.collections.ArrayCollection;
	import mx.containers.Panel;
	import mx.controls.Alert;
	import mx.core.Application;
	import mx.core.Container;
	import mx.core.FlexGlobals;
	import mx.core.UIComponent;
	import mx.events.FlexEvent;
	import mx.formatters.DateFormatter;
	import mx.managers.PopUpManager;
	import mx.resources.ResourceManager;
	
	public class BaseBox extends Panel {
		public var parentWindow:BaseWindow = null;
		public function refreshTab():void {
		}
		
		protected function getLoginUser():UserPrincipal {
			return ClientSession.getLoginUser();
		}
		
		public function isAuthorized(permission:String) : Boolean {
			return ClientSession.isAuthorized(permission);	
		}
		
		public static function isAuthorizedAny(permissions:ArrayCollection) : Boolean {
			return ClientSession.isAuthorizedAny(permissions);
		}
		
		public function handleCchtEvent(key:String, identifier:Object=null):void  {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.eventHandler(key, identifier as NavigationEvent);
			}
		}
		
		public function applicationError(error:Object):void {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.handleAppError(error);
			}
		}
		
		public function handleFlexError(error:Error):void {
			var cchtStage:CchtStage = UIUtils.findCchtStage(this);
			if(cchtStage!=null)
			{
				cchtStage.handleFlexError(error);
			}
		}
		
		public function displayPopup(parent:UIComponent,pop:Container, x:Number = -1,y:Number = -1): void {
			popup(parent,pop,x,y);
		}
		
		public static function popup(parent:UIComponent,popup:Container, x:Number = -1,y:Number = -1, modal:Boolean = true): void {
			popup.x = (x == -1) ? (FlexGlobals.topLevelApplication.width/2) - Math.max(popup.width/2, popup.minWidth/2) : x;
			popup.y = (y == -1) ? AppConstants.POPUP_WINDOW_POSITION_Y : y; 
			PopUpManager.addPopUp(popup, parent, modal);
			PopUpManager.bringToFront(popup);
		}
		
		public function displayAlert(parent:UIComponent,alert:Alert, x:Number = -1,y:Number = -1): void {
			x = (x == -1) ? (FlexGlobals.topLevelApplication.width/2) - (alert.width/2) : x;
			y = (y == -1) ? AppConstants.POPUP_WINDOW_POSITION_Y : x;
			alert.validateNow();
			alert.move(x,y); 
		}
		
		public function showAlert(text:String = "", title:String = "", flags:uint = 0x4, parent:Sprite = null, closeHandler:Function = null, iconClass:Class = null, defaultButtonFlag:uint = 0x4, x:Number = -1, y:Number = -1):void {
			UIUtils.alert(text, title, flags, parent, closeHandler, iconClass, defaultButtonFlag,x,y);
		}
		
		public function setErrorBorder(c:Container, isError:Boolean):void {
			if (c!= null) {
				if (isError) {
					UIUtils.markBoxAsInvalid(c);
				} else {
					UIUtils.markBoxAsValid(c);
				}
			}
		}			
		
		public static function displayOptimisticLockError(parent:UIComponent, callResult:RemoteCallResult): void {
			if(callResult != null && callResult.callStatus != null) {
				var errorType:String = callResult.callStatus;
				var optError:OptimisticLockError = new OptimisticLockError(); 
				optError.errorType = errorType;
				BaseBox.popup(parent,optError);					
			}
		}
		
		public function sortVisn(obj1:Object, obj2:Object):int {
			return SortUtils.sortVisn(obj1, obj2);
		}
		public function getMessage(bundle:String, key:String):String {
			return ResourceManager.getInstance().getString(bundle == null ? "common" : bundle,key);
		}
		public function getNoChangesMessage():String {
			return ResourceManager.getInstance().getString("common","message.nochanges");
		}
		public function getOptimisticLockErrorMessage():String {
			return ResourceManager.getInstance().getString("common","message.optimistic.locking");
		}
	}
}