package gov.va.med.ccht.ui.common.utils {
	
	import gov.va.med.fw.rpc.CustomRemoteObject;
	import gov.va.med.ccht.ui.common.command.ClientSession;
	import gov.va.med.ccht.ui.common.command.CchtServiceLocator;
	
	import mx.rpc.IResponder;
	import mx.rpc.remoting.RemoteObject;
	
	/**
	 * 
	 * @author Muddaiah Ranga
	 */
	public class VersionInfo implements IResponder	{
	
		private static var versionInfo:VersionInfo;
	
  		//Constructor should be private but current AS3.0 does not allow it yet (?)...
  		public function VersionInfo() {
  			if(versionInfo != null) {
  				throw new Error( "Only one VersionInfo instance should be instantiated" );	
  			}
  		}

		public static function getInstance() : VersionInfo {
	      	if(versionInfo == null) {
	      		versionInfo = new VersionInfo();
	      	}
	      	return versionInfo;
	  	}
		
		public function init():void {
			var commonController:RemoteObject = CchtServiceLocator.getInstance().commonController;
			(commonController as CustomRemoteObject).invokeRemoteSimple("getVersion", [], result, fault);
		}
		
		public function result(event:Object):void {
			ClientSession.getInstance().version = event.result;
		}
	
		public function fault(event:Object):void {
			ClientSession.getInstance().version = "Error";
		}
	}
}