package gov.va.med.ccht.ui.common.utils {
	
	import gov.va.med.ccht.ui.encounters.command.EncounterModelLocator;
	import gov.va.med.ccht.ui.common.model.TermTypeWrapper;
	
	import mx.collections.ArrayCollection;
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
	import mx.rpc.Responder;
	import mx.rpc.remoting.RemoteObject;
	
	/**
	 * This is the single location to search terminology codes
	 * 
	 * @author Catherine Anderson
	 */
	public class TermsSearch implements IResponder	{
		
		public static const PROCEDURES:Array = ["gov.va.med.ciss.model.terminology.CPTCode","procedures"];
		public static const DIAGNOSIS_ICD:Array = ["gov.va.med.ciss.model.terminology.ICDCode","diagnosisIcd"];
		public static const DIAGNOSIS_SNOMED:Array = ["gov.va.med.ciss.model.terminology.SNOMEDCode","diagnosisSnomed"];

		private static var termsSearch:TermsSearch;
		private static var terminologyController:RemoteObject;

		[Bindable]
		public var procedures:CustomArrayCollection = new CustomArrayCollection();
		[Bindable]
		public var diagnosisIcd:CustomArrayCollection = new CustomArrayCollection();
		[Bindable]
		public var diagnosisSnomed:CustomArrayCollection = new CustomArrayCollection();
	
  		//Constructor should be private but current AS3.0 does not allow it yet (?)...
  		public function TermsSearch():void {
  			if(termsSearch != null) {
  				throw new Error( "Only one TermsSearch instance should be instantiated" );	
  			}
  		}

		public static function getInstance() : TermsSearch {
	      	if(termsSearch == null) {
	      		termsSearch = new TermsSearch();
	      		terminologyController = ServiceLocator.getInstance().getRemoteObject("terminologyController");
	      	}
	      	return termsSearch;
	  	}
			
		public function searchTerms(name:Array,searchCriteria:String, responder:Responder):void{
			var model : EncounterModelLocator = EncounterModelLocator.getInstance();
			var className:String = name[0];
			var varName:String = name[1];
			var terms:ArrayCollection = this[varName];
			searchCodes(className,varName,searchCriteria, responder);
			if (name == DIAGNOSIS_ICD) {
			    model.dxCodeSearchResults = terms;
			} else {
			    model.pxCodeSearchResults = terms;
			}
		}
		
		private function searchCodes(termType:String,varName:String,searchCriteria:String,homeResponder:Responder) : void {
			var responder:Responder = new Responder(result,fault);
			var call:AsyncToken = terminologyController.searchTermType(termType,varName,searchCriteria)
			call.addResponder(responder);  
			call.addResponder(homeResponder);
		}
	
		public function result(event:Object):void {
			var termWrap:TermTypeWrapper = event.result;
			if(termWrap.terms != null) {
				if(this[termWrap.varName] != null) {
					this[termWrap.varName].removeAll();
					this[termWrap.varName].addAll(termWrap.terms);
				}
			}
		}
	
		public function fault(event:Object):void {
			throw new Error(event.toString());
		}
	}
}