package gov.va.med.ccht.ui.common.utils {
	
	import flash.utils.Dictionary;
	import flash.utils.describeType;
	import flash.utils.getQualifiedClassName;
	
	import gov.va.med.ccht.ui.common.command.CchtServiceLocator;
	import gov.va.med.ccht.ui.common.model.TermTypeWrapper;
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.rpc.CustomRemoteObject;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.controls.Alert;
	import mx.rpc.IResponder;
	import mx.rpc.remoting.RemoteObject;
	import mx.utils.ObjectUtil;
	import mx.utils.UIDUtil;
	
	/**
	 * This is the single location to find the TermTypes. This class need to be intialized 
	 * only once in the application. This class loads all the TermTypes configured.
	 * 
	 * @author Muddaiah Ranga
	 */
	public class TermsCache implements IResponder	{
		
        public static const INACTIVE_REASON:Array = ["gov.va.med.ccht.model.terminology.InactiveReason","inactiveReason"];
        public static const REGISTRATION_DENIED_REASON:Array = ["gov.va.med.ccht.model.terminology.RegistrationDeniedReason","registrationDeniedReason"];
		public static const REGISTRATION_REASON:Array = ["gov.va.med.ccht.model.terminology.RegistrationReason","registrationReason"];
		public static const REGISTRATION_STATUS:Array = ["gov.va.med.ccht.model.terminology.RegistrationStatus","registrationStatus"];
        public static const USER_GROUP:Array = ["gov.va.med.ccht.model.terminology.UserGroup","userGroup"];
        
        //Inventory
        public static const REPORT_WEEK:Array = ["gov.va.med.ccht.model.inventory.ReportWeek","reportWeek"];
        public static const DEVICE_TYPE:Array = ["gov.va.med.ccht.model.inventory.DeviceType","deviceType"];
		public static const DEVICE_VENDOR_TYPE:Array = ["gov.va.med.ccht.model.inventory.DeviceType","deviceVendorType"];
        public static const FACILITY:Array = ["gov.va.med.ccht.model.inventory.SimpleFacility","facility"];
        public static const REPORT_FACILITY:Array = ["gov.va.med.ccht.model.inventory.Facility","reportFacility"];
		public static const ALL_FACILITY:Array = ["gov.va.med.ccht.model.inventory.SimpleFacility","allFacilities"];
        public static const VISN:Array = ["gov.va.med.ccht.model.inventory.SimpleVisn","visn"];
        public static const REPORT_VISN:Array = ["gov.va.med.ccht.model.inventory.SimpleVisn","reportVisn"];
        public static const DEVICE_STATUS_TYPE:Array = ["gov.va.med.ccht.model.inventory.DeviceStatusType","deviceStatusType"];
        public static const DEVICE_DECOMMISSION_REASON:Array = ["gov.va.med.ccht.model.inventory.DeviceDecommissionReason","deviceDecommissionReason"];
		public static const CARE_COORDINATOR:Array = ["gov.va.med.ccht.model.inventory.CareCoordinator","careCoordinator"];
		public static const VENDOR:Array = ["gov.va.med.ccht.model.inventory.Vendor","vendor"];
		public static const DOCUMENT_TYPE:Array = ["gov.va.med.ccht.model.terminology.DocumentType","documentType"];
		public static const QIRSTATUS_TYPE:Array = ["gov.va.med.ccht.model.qir.QIRStatusType","qirStatusType"];
		public static const QIR_TYPE:Array = ["gov.va.med.ccht.model.qir.QIRType","qirType"];

		//Report Specific Lookups
		public static const REPORT_EXPORTED_TYPE:Array = ["gov.va.med.fw.report.ReportExportedType","reportExportedType"];
		public static const WEEK_OF_MONTH:Array = ["gov.va.med.ccht.model.terminology.WeekOfMonth","weekOfMonth"];
		public static const REPORT_RUN_FREQUENCY:Array = ["gov.va.med.ccht.model.terminology.ReportRunFrequency","reportRunFrequency"];
		public static const MONTH:Array = ["gov.va.med.ccht.model.terminology.Month","month"];
		public static const DAY_OF_MONTH:Array = ["gov.va.med.ccht.model.terminology.DayOfMonth","dayOfMonth"];
		public static const DAY_OF_QUARTER:Array = ["gov.va.med.ccht.model.terminology.DayOfQuarter","dayOfQuarter"];
		public static const DAY_OF_WEEK:Array = ["gov.va.med.ccht.model.terminology.DayOfWeek", "dayOfWeek"];
		public static const REPORT_SCHEDULE_TYPE:Array = ["gov.va.med.ccht.model.terminology.ReportScheduleType","reportScheduleType"];
		public static const REPORT_FORMAT:Array = ["gov.va.med.ccht.model.terminology.ReportFormat", "reportFormat"];
		public static const REPORT_PERIOD_TYPE:Array = ["gov.va.med.ccht.model.terminology.ReportPeriodType", "reportPeriodType"];
		public static const QUARTER:Array = ["gov.va.med.ccht.model.terminology.Quarter", "quarter"];
		
		public static const DATE_RANGE_BOUNDARY_TYPE:Array = ["gov.va.med.ccht.model.report.scheduled.DateRangeBoundaryType","dateRangeBoundaryType"];
		public static const FIXED_DATE_TYPE:Array = ["gov.va.med.ccht.model.report.scheduled.FixedDateType","fixedDateType"];
		public static const MULTI_DAY_TIME_UNIT_TYPE:Array = ["gov.va.med.ccht.model.report.scheduled.MultiDayTimeUnitType","multiDayTimeUnitType"];
		public static const SIMPLE_TIME_UNIT_TYPE:Array = ["gov.va.med.ccht.model.report.scheduled.SimpleTimeUnitType","simpleTimeUnitType"];
			
		public static const FLUSHABLE_TYPES_ARRAY:Array = [];

		private static var termsCache:TermsCache;
		
		private static var caches:Dictionary = new Dictionary();
		
		/* key is UID String, unique to the call; value is CustomArrayCollection
			that will be populated asynchronously */
		private static var pendingCalls:Dictionary = new Dictionary(true);
		/* key is UID String, unique to the call; value is some function to run
		after the call completes and the collection is populated */
		private static var pendingCallbackFunctions:Dictionary = new Dictionary(true);
		
		
  		//Constructor should be private but current AS3.0 does not allow it yet (?)...
  		public function TermsCache() {
  			if (termsCache != null) {
  				throw new Error("Only one TermsCache instance should be instantiated");	
  			}
  		}

		public static function getInstance() : TermsCache {
			if (termsCache == null) {
	      		termsCache = new TermsCache();
	      		fillFlashableArray(termsCache as Object);
	      	}
	      	return termsCache;
	  	}
		
		/**
		 * This method retrieves a TermType FOR TERMS THAT HAVE ALREADY BEEN POPULATED
		 * (via getTerms()). To pre-populate terms so this method may be used, add a call
		 * findTerms() in CCHT.mxml at the initialization of the app. CPB
		 */
		public function getTermType(name:Array, value:String) : TermType {
			var terms:ArrayCollection = getTerms(name);
			if (terms != null) {
				for (var i:int = 0; i < terms.length; i++) {
					var termType:TermType = terms.getItemAt(i) as TermType;
					if (termType != null && termType.value == value) {
						return termType;
					}
				}
			}
	 		return null;
		}
		
		/**
		 * This method returns a collection that will eventually contain the terms requested.
		 * If it's the first time we're requesting the specified Terms, we must make a call
		 * to the server. In that case, we return an empty collection immediately which later
		 * on will be asynchronously populated when the server returns. If we've previously
		 * requested the specified terms, we return the cached results. In either case, this
		 * method always returns a CLONE of the results; feel free to filter, sort and
		 * otherwise modify the returned collection without affecting the cache.
		 * 
		 * The callbackFunction, if specified, will be called when the results are ready. It
		 * will be passed a single parameter, which is the populated ArrayCollection. If your
		 * code needs to operate on the populated values of the Term you're interested in, put 
		 * that code into a callbackFunction and do not rely upon the Collection returned from
		 * this method to be immediately populated.
		 * 
		 * CPB
		 */
		public function getTerms(name:Array, callbackFunction:Function = null) : ArrayCollection {
			var className:String = name[0];
			var varName:String = name[1];
			var terms:ArrayCollection = caches[varName] as ArrayCollection;
			if (terms != null && terms.length > 0) {
				var cloneOfCachedResults:ArrayCollection = cloneCustomArrayCollection(terms);
				if (callbackFunction != null)
					callbackFunction(cloneOfCachedResults);
				return cloneOfCachedResults;
			}
			
			var asyncResultCollection:CustomArrayCollection = new CustomArrayCollection();
			var uid:String = UIDUtil.createUID();
			pendingCalls[uid] = asyncResultCollection;
			if (callbackFunction != null)
				pendingCallbackFunctions[uid] = callbackFunction;
			findTerms(className, varName, uid);
			return asyncResultCollection;
		}
		
		private function cloneCustomArrayCollection(cac:ArrayCollection) : ArrayCollection {
			var result:CustomArrayCollection = new CustomArrayCollection();
			result.atomicClearAndAddAll(cac);
			if (cac.sort != null)
				result.sort = ObjectUtil.copy(cac.sort) as Sort;
			if (cac.filterFunction != null)
				result.filterFunction = cac.filterFunction;
			result.refresh();
			return result;
		}
		
		private function findTerms(termType:String, varName:String, uid:String) : void {
			var tc:RemoteObject = CchtServiceLocator.getInstance().terminologyController;			
			
			if (termType == VISN[0] && varName == VISN[1]) {				
				(tc as CustomRemoteObject).invokeRemoteSimple("getVisns", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == REPORT_VISN[0] && varName == REPORT_VISN[1]) {				
				(tc as CustomRemoteObject).invokeRemoteSimple("getReportVisns", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == REPORT_FACILITY[0] && varName == REPORT_FACILITY[1]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getReportFacilities", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == FACILITY[0] && varName == FACILITY[1]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getFacilities", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == ALL_FACILITY[0] && varName == ALL_FACILITY[1]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getAllFacilities", 
					[termType, varName, true, uid], result,	fault);
			}			
			else if (termType == REPORT_WEEK[0]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getReportWeeks", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == DEVICE_TYPE[0] && varName == DEVICE_TYPE[1]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getDeviceTypes", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == DEVICE_VENDOR_TYPE[0] && varName == DEVICE_VENDOR_TYPE[1]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getVendorByDevice", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == VENDOR[0]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getVendors", 
					[termType, varName, true, uid], result,	fault);
			}
			else if (termType == CARE_COORDINATOR[0]) {
				(tc as CustomRemoteObject).invokeRemoteSimple("getCareCoordinators", 
					[termType, varName, true, uid], result,	fault);
			}
			else {
				(tc as CustomRemoteObject).invokeRemoteSimple("getWrappedTermType", 
					[termType, varName, true, uid],	result, fault);
			} 
		}
	
		public function result(event:Object) : void {
			var termWrap:TermTypeWrapper = event.result;
			if (termWrap != null && termWrap.terms != null) {
				if (caches[termWrap.varName] == null)
					caches[termWrap.varName] = new CustomArrayCollection();
				
				var col:CustomArrayCollection = (caches[termWrap.varName] as CustomArrayCollection);
				col.atomicClearAndAddAll(termWrap.terms);
				postProcess(termWrap.varName, col);
				
				if (pendingCalls.hasOwnProperty(termWrap.callUID)) {
					var asyncResultCollection:CustomArrayCollection =
						(pendingCalls[termWrap.callUID] as CustomArrayCollection);
					asyncResultCollection.atomicClearAndAddAll(termWrap.terms);
					postProcess(termWrap.varName, asyncResultCollection);
					delete pendingCalls[termWrap.callUID];
					
					if (pendingCallbackFunctions[termWrap.callUID] != null) {
						(pendingCallbackFunctions[termWrap.callUID] as Function)(asyncResultCollection);
						delete pendingCallbackFunctions[termWrap.callUID];
					}
				}
			}
		}
		
		private function enabledFilter(o:Object):Boolean{
			return (o as TermType).enabled;
		}
		
		public function postProcess(termName:String, col:CustomArrayCollection) : void {
			if(termName == "country") {
				postProcess_country(col);
			} 
		}
						
		private function postProcess_country(country:CustomArrayCollection) : void {
			var usa:String = "USA";
			
			if ((country.getItemAt(0) as TermType).value != usa) {
				for (var i:int = 0; i < country.length; i++) {
					var t:TermType = country.getItemAt(i) as TermType;
					if (t.value == usa) {
						country.addItemAt(country.removeItemAt(i), 0);
						return;
					}
				}
			}
		}

		
		public function fault(event:Object):void {
			Alert.show( "Error while retriving Terms!" + event);
			throw new Error(event.toString());
		}
		
		public function flushCache(cacheClassName:String, refetch:Boolean=true):void {
			for (var i:int = 0; i < FLUSHABLE_TYPES_ARRAY.length; i++) {
				if (FLUSHABLE_TYPES_ARRAY[i][0] == cacheClassName) {
					var c:ArrayCollection = caches[FLUSHABLE_TYPES_ARRAY[i][1]] as ArrayCollection;
					if (c != null) {
						c.removeAll();
						c.refresh();
					}
					
					if (refetch)
						getTerms(FLUSHABLE_TYPES_ARRAY[i]);	
					
					break;
				}
			}
		}
		
		private static function fillFlashableArray(objectOfInterest:Object):void {
			var clazz:Class = flash.utils.getDefinitionByName(flash.utils.getQualifiedClassName(objectOfInterest)) as Class
			var xmlDescriptionOfClass:XML = describeType(clazz);
			var staticPropertiesXML:XMLList = xmlDescriptionOfClass.constant;
			var staticProperties:Array = [];

			for each (var propertyXML:XML in staticPropertiesXML) {
				if (propertyXML.@type.toString() == "Array") {
					var constName:String = propertyXML.@name.toString();
					var arr:Array = clazz[constName] as Array;	
					FLUSHABLE_TYPES_ARRAY.push(arr);
				}
			}
		}
		
		public function getReportTypes():ArrayCollection {
			var terms:ArrayCollection = new ArrayCollection();
				terms.addItem(TermType.create("National","National"));
				terms.addItem(TermType.create("VISN","VISN"));
				terms.addItem(TermType.create("Facility","Facility"));
			return terms;
		}
		
		public function getReportSubTotalTypes():ArrayCollection {
			var terms:ArrayCollection = new ArrayCollection();
				terms.addItem(TermType.create("Vendor","Vendor"));
				terms.addItem(TermType.create("Device Model","Device Model"));
			return terms;
		}
		
		public function getDataGridRowCountTypes():ArrayCollection {
			var terms:ArrayCollection = new ArrayCollection();
			terms.addItem(TermType.create("10","10"));
			terms.addItem(TermType.create("25","25"));
			terms.addItem(TermType.create("50","50"));
			terms.addItem(TermType.create("75","75"));
			terms.addItem(TermType.create("100","100"));
			return terms;
		}
	}
}