package gov.va.med.ccht.ui.common.utils
{
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.filters.DropShadowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    import gov.va.med.fw.utils.PreloaderBase;
    
    public class CustomPreloader extends PreloaderBase
    {
    	[Embed(source="/../resources/images/ccht_splash.png")]
        [Bindable] public var Logo:Class;  

        private var t:TextField;
        private var f:DropShadowFilter=new DropShadowFilter(2,40,0x000000,0.5)
        private var logoDisplayObject:DisplayObject;
        private var bar:Sprite=new Sprite();
        private var barFrame:Sprite;
        //private var mainColor:uint=0x00AEEF;
        private var mainColor:uint=0x6699CC;
        
        public function CustomPreloader()
        {
            super();
        }
        
        // This is called when the preloader has been created as a child on the stage.
        //  Put all real initialization here.
        override public function initialize():void
        {
            super.initialize();
            
            //clear();  // clear here, rather than in draw(), to speed up the drawing
            
            //var indent:int = 20;
            //var height:int = 20;
            
            //creates all visual elements
			this.visible=false;
            createAssets();
			this.visible=true;
        }
        
        //this is our "animation" bit
        override protected function draw():void
        {            
            //make objects below follow loading progress
            //positions are completely arbitrary
            //d tells us the x value of where the loading bar is at
            var d:Number=barFrame.x + barFrame.width * _fractionLoaded
            
            t.text = int(_fractionLoaded*100).toString()+"% loaded";            
            
            // these commented out lines have the logo+text sliding into the middle
			//t.x = d - t.width - 25;
            //logoDisplayObject.x = d - logoDisplayObject.width;
            //logoDisplayObject.x = d - barFrame.width + 50; // includes an offset
			t.x = barFrame.x + barFrame.width - t.width - 25;
            logoDisplayObject.x = barFrame.x + 50;
            
            bar.graphics.beginFill(mainColor,1)
            bar.graphics.drawRoundRectComplex(0,0,bar.width * _fractionLoaded,15,12,0,0,12);
            bar.graphics.endFill();
        }
        
        protected function createAssets():void
        {
            //create the logo
            logoDisplayObject = new Logo();
            //logoDisplayObject.y = stageHeight/2 - logoDisplayObject.height*1.5;
            logoDisplayObject.y = 30;
            //logoDisplayObject.filters = [f];
            
            //craate bar
            bar = new Sprite();
             bar.graphics.drawRoundRectComplex(0,0,400,15,12,0,0,12);
            bar.x = stageWidth/2 - bar.width/2;
            //bar.y = stageHeight/2 - bar.height/2;
            bar.y = 30 + logoDisplayObject.height + 5;
            //bar.filters = [f];
            
            //create bar frame
            barFrame = new Sprite();
            //barFrame.graphics.lineStyle(2,0x000000,1)
            barFrame.graphics.lineStyle(1,0x000000,1)
            barFrame.graphics.drawRoundRectComplex(0,0,400,15,12,0,0,12);
            barFrame.graphics.endFill();
            barFrame.x = stageWidth/2 - barFrame.width/2;
            //barFrame.y = stageHeight/2 - barFrame.height/2;
            barFrame.y = 30 + logoDisplayObject.height + 5;
            //barFrame.filters = [f];
            
            //create text field to show percentage of loading
            t = new TextField()
            t.y = barFrame.y-27;
            t.filters=[f];
			
            //we can format our text
            var s:TextFormat=new TextFormat("Verdana",null,0x000000,null,null,null,null,null,"right");
            t.defaultTextFormat=s;
			
			addChild(logoDisplayObject);
			addChild(bar);
			addChild(barFrame);
			addChild(t);
        }
        
        protected function clear():void 
        {    
            /*// Draw gradient background
            var b:Sprite = new Sprite;
             var matrix:Matrix =  new Matrix();
            matrix.createGradientBox(stageWidth, stageHeight, Math.PI/2);   
            b.graphics.beginGradientFill(GradientType.RADIAL,   
                                        [mainColor, mainColor],             
                                        [0,128],                           
                                        [0,255],
                                        matrix
                                        );
            b.graphics.drawRect(0, 0, stageWidth, stageHeight);
            b.graphics.endFill(); 
            addChild(b);*/
        }

    }        
}