package gov.va.med.ccht.ui.common.model
{

	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.model.inventory.VCReportData")]
	
	public class VCReportData {	
		public var reportEndDate:Date;
		public var vendorName:String;
		public var deviceCount:Number;
		public var modelNameCount:Number;
		public var serialNumberCount:Number;

		public function get modelNamePercent():Number { 
			if (deviceCount > 0) {
				return (Math.round(modelNameCount*100.0/deviceCount)); 
			} else {
				return 0;
			}
		}
		public function get serialNumberPercent():Number { 
			if (deviceCount > 0) {
				return (Math.round(serialNumberCount*100.0/deviceCount)); 
			}else {
				return 0;
			}
		}
	}
}
