package gov.va.med.ccht.ui.common.model {
	
	import gov.va.med.fw.utils.EqualsBuilder;
	import gov.va.med.fw.utils.FormatUtils;
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.UserForm")]
	public class User extends Form{
		
		public var userName:String;
		public var givenName:String;
		public var middleName:String;
		public var familyName:String;
		public var title:String;
		public var department:String;
		public var description:String;
		public var office:String;
		public var telephoneNumber:String;
		public var email:String;
		public var registrationReason:TermType;
		public var password:String;
		
		public var inactiveReason:TermType;
		public var registrationDeniedReason:TermType;
		public var registrationStatus:TermType;
		public var visn:TermType;
		public var facility:TermType;
		public var secondaryFacility:TermType;
		public var userGroup:TermType;
		public var vendor:TermType;
		public var accountExpireDate:Date;
		public var accountLockDate:Date;
		public var inactiveDate:Date;
		public var loginFailedDate:Date;
		public var lastLoginDate:Date;
		
		public var  loginFailedCount:int;
	
		public var roles:ArrayCollection;
		public var availableRoles:ArrayCollection;
		
		public var address:Address;
			
		public var locked:Boolean;
		public var inactive:Boolean;
			
		//User Preferences
		public var multipleWindows:Boolean = false;
		public var audio:Boolean = true;
		
		public function User() {
		}
		
		public function get fullName():String {
			return FormatUtils.formatName(givenName, middleName, familyName);
		}
		public function get visnName():String {
			return visn == null ? null : visn.label;
		}
		public function get facilityName():String {
			return facility == null ? null : facility.label;
		}	
		public function get secondaryFacilityName():String {
			return secondaryFacility == null ? null : secondaryFacility.label;
		}		
		public function get registrationStatusLabel():String {
			return registrationStatus == null ? null : registrationStatus.label;
		}
		public function get registrationReasonLabel():String {
			return registrationReason == null ? null : registrationReason.label;
		}
		public function get registrationDeniedReasonLabel():String {
			return registrationDeniedReason == null ? null : registrationDeniedReason.label;
		}
		public function get inactiveReasonLabel():String {
			return inactiveReason == null ? null : inactiveReason.label;
		}
		public function get userGroupLabel():String {
			return userGroup == null ? null : userGroup.label;
		}
		
		public function hasRole(roleName:String):Boolean {
			if (roles != null) {
				for each (var tt:TermType in roles) {   
					if (tt.value ==  roleName)
						return true;
				} 
			}
			return false;
		}		
		
		public function get rolelist():String {
			var rolelist:String = "";
			if (roles != null && roles.length > 0) {
				rolelist += (roles.getItemAt(0) as TermType).value;
				for (var index:int=1; index< roles.length; index++) {
					rolelist += ", " + (roles.getItemAt(index) as TermType).value;
				} 
			}
			return rolelist;
		}
		
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is User) {
				var other:User = object as User;
				return new EqualsBuilder()
					.append(inactiveReason, other.inactiveReason)
					.append(registrationDeniedReason, other.registrationDeniedReason)
					//.append(registrationStatus, other.registrationStatus)
					.append(visn, facility == null ? other.visn : visn)
					.append(facility, other.facility)
					.append(secondaryFacility, other.secondaryFacility)
					.append(vendor, other.vendor)
					.append(inactiveDate, other.inactiveDate)
					.append(roles, other.roles)
					.append(locked, other.locked)
					.append(inactive, other.inactive)
					.append(multipleWindows, other.multipleWindows)
					.append(audio, other.audio)
					.equals;			
			}
			else {
				return false;
			}
		}
	}
}
