//System user to create and update users in ciss

package gov.va.med.ccht.ui.common.model {

	import gov.va.med.fw.utils.FormatUtils;
	import gov.va.med.fw.utils.EqualsBuilder;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.model.inventory.ReportWeek")]
	public class ReportWeek implements IEquals, IMatch{
		
		public var startDate:Date;
		public var endDate:Date;
  	
		public function ReportWeek() {
			//default values
		}
		public function equals(object:Object):Boolean {
			if (!object) return false;
			if (object is ReportWeek) {
				var other:ReportWeek = object as ReportWeek;				
					return new EqualsBuilder()
					.append(startDate, other.startDate)
					.equals;			
			}
			else {
				return false;
			}
		}
		
		public function match(object:Object):Boolean {
			return equals(object);
		}		
		public function get label():String {
			return FormatUtils.formatDate(startDate) + " - " + FormatUtils.formatDate(endDate)
		}
		public function get value():ReportWeek {
			return this;
		}		
	}
}
