package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.utils.EqualsBuilder;
	import gov.va.med.fw.utils.FormatUtils;
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;
	import mx.utils.StringUtil;
	
	[Bindable] [RemoteClass(alias="gov.va.med.ccht.ui.model.QIRForm")]
	
	public class QIR extends Form implements IEquals
	{		
		public var qirType:TermType;
		public var qirStatusType:TermType;
		public var visn:TermType;
		public var facility:TermType;
		public var deviceType:TermType;
		public var vendor:TermType;
		public var serialNumber:String;
		public var purchaseOrderNumber:String;
		public var submittedDate:Date;	
		public var vendorResponseDueDate:Date;
		public var emailReminderSentDate:Date;
		public var statusChangeDate:Date;
		public var complaint:String;
		public var headline:String;
		public var submittedBy:String;
		public var submittedByName:String;
		public var remarks:String;
		public var remarksHistory:String;
		public var vendorActions:String;
		public var vendorActionsHistory:String;
		public var attachments:ArrayCollection = new ArrayCollection();
				
		public function QIR()
		{
			super();
		}
		
		public function get headerDisplayText():String {
			return "TN: " + id + " - " + getLabel(qirStatusType) + " - " + headline + "; " + submittedByName + " " + 
				StringUtil.trim(getLabel(visn)) + " " + StringUtil.trim(getLabel(facility)) ;
		}
		private function getLabel(tt:TermType):String {return tt==null ? "" : tt.label;}
		
		public function get formattedSubmittedDate():String {
			return submittedDate == null ? "" : FormatUtils.formatDate(submittedDate);
		}
		public function get formattedVendorResponseDueDate():String {
			return vendorResponseDueDate == null ? "" : FormatUtils.formatDate(vendorResponseDueDate);
		}
		
		public function get attachmentCount():int {
			return (attachments != null) ? attachments.length : 0;
		}
		
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is QIR) {
				var other:QIR = object as QIR;				
				return new EqualsBuilder()
				.append(qirType, other.qirType)
					.append(qirStatusType, other.qirStatusType)
					.append(deviceType, other.deviceType)
					.append(vendor, other.vendor)
					.append(serialNumber, other.serialNumber)
					.append(purchaseOrderNumber, other.purchaseOrderNumber)					
					.append(vendorResponseDueDate, other.vendorResponseDueDate)
					.append(emailReminderSentDate, other.emailReminderSentDate)
					.append(statusChangeDate, other.statusChangeDate)
					.append(complaint, other.complaint)
					.append(headline, other.headline)
					.append(nullToString(remarks), nullToString(other.remarks))
					.append(nullToString(vendorActions), nullToString(other.vendorActions))
					.append(attachmentCount, other.attachmentCount)
					.equals;					
				//.append(visn, other.visn)
				//.append(facility, other.facility)
				//.append(submittedDate, other.submittedDate)
				//.append(submittedBy, other.submittedBy)
				//.append(submittedByName, other.submittedByName)
			}
			else {
				return false;
			}
			return false;
		}
		private function nullToString(a:String):String {
			return a==null ? "" : a;
		}
	}
}