package gov.va.med.ccht.ui.common.model
{
	
	import mx.formatters.DateFormatter;

	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.FormattedDateForm")]

	public class FormattedDate
	{
		private var _date:Date;		
		public var formattedDate:String;		
		
		public function FormattedDate()
		{
		}
		
		public function set date(date:Date) : void {
			this._date = date;
			if(this.formattedDate == null) {
				var df:DateFormatter = new DateFormatter();
    			df.formatString="MM/DD/YYYY JJ:NN";
    			this.formattedDate = df.format(date);
			}
		}
		
		public function get date() : Date {
			return this._date;	
		}
		
		public function getFormattedTime():String {
			return formattedDate.substring(11, 16);
		}
		
		public function getTimeZone():String {
			return formattedDate.substring(17, formattedDate.length);
		}
		
		/**
		 * Returns the date in YYYY-MM-DD format, which can be compared alphabetically against
		 * other Strings in this format in the same order as if the actual dates were compared
		 */
		public function getAlphaComparableDateOnly() : String {
			var df:DateFormatter = new DateFormatter();
    		df.formatString="YYYY-MM-DD";
    		return df.format(date);
		}
		
		public function getFormattedDateOnly():String {

			/*
			var df:DateFormatter = new DateFormatter();
			df.formatString="MM/DD/YYYY";
			return df.format(_date);
			*/

			return (formattedDate != null && formattedDate.length >= 10) ? formattedDate.substring(0, 10) : formattedDate;
		}
		
		public static function formatDate(dt:Date):String {
			if(dt != null) {
				var df:DateFormatter = new DateFormatter();
    			df.formatString="MM/DD/YYYY JJ:NN";
    			return df.format(dt);
			}
			return "";
		}
	}
}