package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.utils.FormatUtils;
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;

	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.model.inventory.DeviceSearchParameters")]
	
	public class DeviceSearchParameters {	
		public var searchType:TermType;
		public var deviceType:TermType;
		public var serialNumber:String;
		public var fromSerialNumber:String;
		public var toSerialNumber:String;
		public var fromActivationDate:Date;
		public var toActivationDate:Date;
		public var lastName:String;
		public var firstName:String;
		public var middleName:String;
		public var ssn:String;
		public var icn:String;
		public var reportWeek:ReportWeek;
		public var deviceStatuses:ArrayCollection;
		public var allDeviceStatuses:Boolean;
		public var facility:TermType;
		public var careCoordinator:TermType;
		
		public function get patientName():String {
			var name:String = lastName == null ? "" : lastName + ", ";
			return firstName == null ? name : name + firstName;			
		}
		
		public function get selectedStatuses():String {
			if (allDeviceStatuses) {
				return "All";
			}else {
				return FormatUtils.formatTermTypeList(deviceStatuses);
			}
		}
	}
}
