package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.EqualsBuilder;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.DeviceRequirementForm")]
	
	public class DeviceRequirement extends Form implements IEquals
	{
		public var facility:TermType;
		public var deviceType:TermType;
		public var assessmentDate:Date;		
		public var devicesOnHand:int = 0;
		public var devicesNeeded:int = 0;
		
		public function DeviceRequirement() {}
		
		public function get deviceName (): String {
			return deviceType == null ? "" : deviceType.label;
		}
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DeviceRequirement) {
				var other:DeviceRequirement = object as DeviceRequirement;
				return new EqualsBuilder()
				.append(deviceType, other.deviceType)
				.append(devicesNeeded, other.devicesNeeded)
				.equals;			
			}
			else {
				return false;
			}
		}
	}
}