package gov.va.med.ccht.ui.common.model
{
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.EqualsBuilder;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.model.DeviceDetailForm")]
	
	public class DeviceDetail extends Form implements IEquals
	{
		public var facility:TermType;
		public var deviceDecommissionReason:TermType;
		public var deviceType:TermType;
		public var serialNumber:String;
		public var eeNumber:String;
		public var purchaseOrderNumber:String;
		public var dateOfPurchase:Date;
		public var warrantyFromDate:Date;
		public var warrantyToDate:Date;
		public var multiPatientUsage:Boolean;
		public var lastActiveDate:Date;
		public var deviceStatus:DeviceStatus;
		public var deviceStatusHistory:ArrayCollection;

		public function DeviceDetail() {}
		public function get kiosk():String {
			return multiPatientUsage ? "Yes" : "No"
		}
		
		public function equals(object:Object):Boolean {
			if (!object) { return false; }
			if (object == this) { return true; }
			if (object is DeviceDetail) {
				var other:DeviceDetail = object as DeviceDetail;
				return new EqualsBuilder()
					.append(eeNumber, other.eeNumber)
					.append(purchaseOrderNumber, other.purchaseOrderNumber)
					.append(dateOfPurchase, other.dateOfPurchase)
					.append(warrantyFromDate, other.warrantyFromDate)
					.append(warrantyToDate, other.warrantyToDate)
					.append(deviceStatus, other.deviceStatus)
					.equals;			
			}
			else {
				return false;
			}
		}
	}
}