package gov.va.med.ccht.ui.common.command {
	
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.ccht.ui.common.ControllerResult")]
	public class RemoteCallResult {
		
		public static const SUCCESS:String 	= "SUCCESS";
		public static const WARNING:String 	= "WARNING";
		public static const ERROR:String 	= "ERROR";
		public static const ALREADY_EXISTS:String = "ALREADY_EXISTS";
		public static const DATA_CHANGED:String = "DATA_CHANGED";
		
		public var callStatus:String;
		public var messages:ArrayCollection;
		public var warnings:ArrayCollection;
		public var errors:ArrayCollection;
	
		public function RemoteCallResult() {}
		public function isSuccess():Boolean {return (SUCCESS == callStatus); }
		public function isError():Boolean {return (ERROR == callStatus); }
		public function isWarning():Boolean {return (WARNING == callStatus); }
		public function isAlreadyExists():Boolean {return (ALREADY_EXISTS == callStatus); }
		public function isDataChanged():Boolean {return (DATA_CHANGED == callStatus); }
	}
}