package gov.va.med.ccht.ui.common.command {
	
	import gov.va.med.ccht.ui.common.model.UserPrincipal;
	
	import mx.collections.ArrayCollection;
	
	[Bindable]
	public class ClientSession {
		
		public var clientSessionParameters:ClientSessionParameters;
		public var registeredUserName:String;
		
      	public static function getInstance() : ClientSession {
      		
	      	if(clientSession == null) {
	      		clientSession = new ClientSession();
	      	}
	      	return clientSession;
	  	}
           
      	//Constructor should be private but current AS3.0 does not allow it yet (?)...
      	public function ClientSession() {
         	if(clientSession != null) {
         		throw new Error( "Only one ClinetSession instance should be instantiated" );	
         	}
      	}

		//Verify that user logged in and is authorized
		public static function isAuthorized(permissionName:String) : Boolean {
			if (clientSession != null && 
				clientSession.clientSessionParameters != null && 
				clientSession.clientSessionParameters.user != null) {
				return clientSession.clientSessionParameters.user.isAuthorized(permissionName);
			}
			return false;
		}

		public static function isAuthorizedAny(permissions:ArrayCollection) : Boolean {
            if (clientSession != null && 
				clientSession.clientSessionParameters != null && 
				clientSession.clientSessionParameters.user != null) {
				return clientSession.clientSessionParameters.user.isAuthorizedAny(permissions);
			}
			return false;
		}
						
      	public static function getLoginUserId():String {
      		if (clientSession != null && 
				clientSession.clientSessionParameters != null && 
				clientSession.clientSessionParameters.user != null) {
				return clientSession.clientSessionParameters.user.userName;
			}
			return "";
      	}
   
      	public static function getLoginUser():UserPrincipal {
      		if (clientSession != null && clientSession.clientSessionParameters != null && clientSession.clientSessionParameters.user != null) {
				return clientSession.clientSessionParameters.user;
			}
			return null;
      	}
		
		public static function get multipleWindows():Boolean {
			var userP:UserPrincipal = getLoginUser();
			if (userP != null) {
				return userP.multipleWindows;
			}else {
				return true;
			}
		}
		
		public static function get audio():Boolean {
			var userP:UserPrincipal = getLoginUser();
			if (userP != null) {
				return userP.audio;
			}else {
				return true;
			}
		}
      	      	
      	public function getVersion():String {
      		if (clientSession != null && clientSession.clientSessionParameters != null) {
      			return clientSession.clientSessionParameters.version;
      		}else {
      			return "1.0";
      		}
      	}
      	private static var clientSession : ClientSession;
	}
}