package gov.va.med.ccht.ui.common.command {
	import mx.core.FlexGlobals;
	import mx.core.Application;
	import mx.rpc.remoting.RemoteObject;
	
	public class CchtServiceLocator {
		
		public var terminologyController : RemoteObject;
		public var securityController : RemoteObject;
		public var securityControllerNonUI : RemoteObject;
		public var inventoryController : RemoteObject;
		public var qirController : RemoteObject;
		public var reportController : RemoteObject;
		public var batchProcessController : RemoteObject;
		
		public function CchtServiceLocator() {
			if(cchtServiceLocator != null) {
	            throw new Error("SINGLETON_EXCEPTION CchtServiceLocator" );
	         }
			cchtServiceLocator = this;
		}
		
		private static var cchtServiceLocator:CchtServiceLocator = null;
		
		internal static function getInternalInstance() : CchtServiceLocator
		{
			return cchtServiceLocator;
		}
		
	    public static function getInstance() : CchtServiceLocator  {
	         if (cchtServiceLocator == null) {
	        	cchtServiceLocator = new CchtServiceLocator();
	        	cchtServiceLocator.terminologyController = FlexGlobals.topLevelApplication.terminologyController;
	        	cchtServiceLocator.securityController = FlexGlobals.topLevelApplication.securityController;
	        	cchtServiceLocator.securityControllerNonUI = FlexGlobals.topLevelApplication.securityControllerNonUI;
	        	cchtServiceLocator.inventoryController = FlexGlobals.topLevelApplication.inventoryController;
				cchtServiceLocator.qirController = FlexGlobals.topLevelApplication.qirController;
	        	cchtServiceLocator.reportController = FlexGlobals.topLevelApplication.reportController;
	        	cchtServiceLocator.batchProcessController = FlexGlobals.topLevelApplication.batchProcessController;
	         }
	         return cchtServiceLocator;
	      }
	}
}