package gov.va.med.fw.validators { 
	import gov.va.med.fw.utils.StringUtils;
	
	import mx.controls.Alert;
	import mx.utils.StringUtil;
	import mx.validators.EmailValidator;
	import mx.validators.ValidationResult;
	import mx.validators.Validator;
	
	/**
	 *	Supports both generic email addresses and domain specific e-mail addresses
	 */
	
	[ResourceBundle("validators")]
	public class YesNoValidator extends CustomValidator 
	{
		
		public static const REGEX : RegExp = /^(Yes|yes|YES|No|NO|no)($|\s|-|,|:|;|~|&).*/; 
		
		private var results:Array = null;
		private var invalidError:String = "{fieldLabel} must start with either 'Yes' or 'No'.";
		
		public function YesNoValidator() 
		{
			super();
		}
		
		/**
		 *	Override the method to validate multiple e-mail addresses
		 */
		override protected function doValidation(value:Object):Array
		{
			//do the default validation
			results = [];
			results = super.doValidation(value);
			if (results.length > 0) 
			{
				results;
			}
			
			//convert to a string for validation string
			var text:String = value as String;
			
			if (text != null || text.length > 0) 
			{				
				//validate each email address
				if (!isValidYesNo(text)) 
				{
					results.push(new ValidationResult(true, null, null, invalidYnError));
				} 
			}
			return results;
		}
		
		/**
		 *  Error message when the email address is invalid
		 *  @default requiredFieldError={fieldLabel} email address is inavlid.
		 */
		public function get invalidYnError():String 
		{
			return ValidatorUtil.replaceWithLabel(this.invalidError, fieldLabel);
		}
		
		public function set invalidYnError(invalidError:String):void 
		{
			if (invalidError != null && invalidError.length > 0) 
			{
				this.invalidError=invalidError;
			}
		}		
		
		public static function isValidYesNo(text:String) : Boolean
		{
			text = StringUtil.trim(text);
			
			return (Boolean(text.match(REGEX)));
		}
		
		
	}
}