package gov.va.med.fw.validators {
	import gov.va.med.fw.utils.StringUtils;
	
	import mx.controls.DateField;
	import mx.events.ValidationResultEvent;
	import mx.validators.ValidationResult;
	
	public class ValidatorUtil {
		
		public static const DATE_FORMAT_MMDDYYYY:String 			= "MM/DD/YYYY";
		
		public static var fieldLabel:String = "fieldLabel";
		
		public function ValidatorUtil() {}
		
		public static function replaceWithLabel(string:String,label:String):String {
			if(StringUtils.isEmpty(string ) || StringUtils.isEmpty(label)) {
				return string;
			}
			label = (label.lastIndexOf(":") == -1) ? label : label.substring(0,label.lastIndexOf(":"));
			return string.replace(new RegExp("\\{"+ fieldLabel +"\\}", "g"), label);
		}
		
		public static function isStartAndEndDatesValid(startDate:String,endDate:String):Boolean {
			if(StringUtils.isEmpty(startDate) || StringUtils.isEmpty(endDate)) {
				return true;
			}
			var start:Date = DateField.stringToDate(startDate,DATE_FORMAT_MMDDYYYY);
			var end:Date = DateField.stringToDate(endDate,DATE_FORMAT_MMDDYYYY);
			if(start != null && end != null && start.getTime() <= end.getTime()) {
				return true;
			}
			return false;
		}
			
		public static function createValidationResultEvent(fieldName:String,errorMessage:String):ValidationResultEvent {
				var valResult:ValidationResult = new ValidationResult(true,fieldName,"",errorMessage);
				var resultEvent:ValidationResultEvent = new ValidationResultEvent(ValidationResultEvent.INVALID);
				resultEvent.field = errorMessage;
				resultEvent.results = new Array(valResult);
				return resultEvent;
			}
	}
}