package gov.va.med.fw.validators {
	import mx.validators.ZipCodeValidator;

	[ResourceBundle("validators")]
	public class CustomZipCodeValidator extends ZipCodeValidator 	{
		
		public function CustomZipCodeValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/** 
     	 *  Error message when the ZIP code contains invalid characters.
	 	 *
	 	 *  @default "invalidCharError"
     	 */
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
		/** 
     	 *  Error message when the <code>domain</code> property contains an invalid value.
	 	 *
	 	 *  @default "invalidDomainError"
     	 */
		override public function get invalidDomainError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidDomainError, fieldLabel);
		}
	
		/** 
     	 *  Error message for an invalid Canadian postal code.
	 	 *
	 	 *  @default "wrongCAFormatError"
     	 */
		override public function get wrongCAFormatError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongCAFormatError, fieldLabel);
		}
	
		/** 
     	 *  Error message for an invalid US ZIP code.
	 	 *
	 	 *  @default "wrongLengthError"
     	 */
		override public function get wrongLengthError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongLengthError, fieldLabel);
		}
	
		/** 
     	 *  Error message for an incorrectly formatted ZIP code.
	 	 *
	 	 *  @default "wrongUSFormatError"
     	 */
		override public function get wrongUSFormatError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongUSFormatError, fieldLabel);
		}
	}
}