package gov.va.med.fw.validators {
    import mx.collections.ArrayCollection;

    [ResourceBundle("validators")]
    public class CustomRequiredFieldValidator extends CustomStringValidator {

        private var results:Array;

        public function CustomRequiredFieldValidator() {
	    super();
        }

        /*
        * if contingentField is equal to either fieldValue or fieldValue2 then validate the fieldToValidate.
        * if there is a secondayConditionField then it must equal the secondaryConditionValue before validating.
        */
        override protected function doValidation(value:Object):Array {
            var contingentField:String = value.contingentField;
            var contingentFields:ArrayCollection = value.contingentFields;
            var secondaryConditionField:String = value.secondaryConditionField;
            var secondaryConditionValue:String = value.secondaryConditionValue;
            var fieldToValidate:String = value.fieldToValidate;
            var fieldValue:String = value.fieldValue;
            var fieldValue2:String = value.fieldValue2;

            // Clear results Array.
            results = [];
	        if (contingentField == null) {
	        	for each (var contingentValue:String in contingentFields) {
	        		if (contingentValue == fieldValue)
	        		    results = super.doValidation(fieldToValidate);
	        	}
	        } else {
	            if (contingentField == fieldValue || (contingentField != null && contingentField == fieldValue2)) {
	            	if (secondaryConditionField != null) {
	            	    if (secondaryConditionField == secondaryConditionValue)	
	            	        results = super.doValidation(fieldToValidate);
	            	} else {
	                    results = super.doValidation(fieldToValidate);
	                }
	            }
            }
            return results;
        }


		
    }
}