package gov.va.med.fw.validators {
	import mx.validators.RegExpValidator;

	[ResourceBundle("validators")]
	public class CustomRegExpValidator extends RegExpValidator {
		
		public function CustomRegExpValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/** 
     	 *  Error message when there are no matches to the regular expression. 
     	 *  @default noMatchError={fieldLabel} is invalid.
     	 */
		override public function get noMatchError():String {
			return ValidatorUtil.replaceWithLabel(super.noMatchError, fieldLabel);
		}
	}
}