package gov.va.med.fw.validators {
    import gov.va.med.fw.controls.DateField;
    
    import mx.validators.ValidationResult;

    [ResourceBundle("validators")]
    public class CustomOrderedDateValidator extends CustomValidator {

        private var results:Array;
        
        public var section:Object;
        public var maxNumDates:int;
		public var dateInputFunction:Function;
		public var dateConsiderationFunction:Function;
		
        public function CustomOrderedDateValidator() {
	    	super();
        }

        override protected function doValidation(value:Object):Array {
        	results = [];
            var vals:Array = new Array();
      		
        	for (var i:int = 1; i <= maxNumDates; i++) {
        		if (dateConsiderationFunction != null && !dateConsiderationFunction(i))
        			continue;
        		
        		var dateInput:DateField = dateInputFunction != null ? dateInputFunction(i) :
        			section["dose" + i + "Date"] as DateField;
        		
        		var testDate:Date = dateInput.selectedDate;
        		if (testDate != null)
        			vals.push(testDate);
            }
            
            var lastDate:Date = null;
            for (var j:int = 0; j < vals.length; j++) {
            	var currentDate:Date = (vals[j] as Date);
            	if (lastDate != null && currentDate <= lastDate) {
		            var result:ValidationResult = new ValidationResult(true, "", "validationFailed", fieldLabel);  
		            results.push(result);
		            break;
            	}
            	lastDate = currentDate;
            }
			
	        return results;
    	}
            
    }
}