package gov.va.med.fw.validators {
	import mx.validators.NumberValidator;

	[ResourceBundle("validators")]
	public class CustomNumberValidator extends NumberValidator {
		
		public function CustomNumberValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/**
     	 *  Error message when the value exceeds the <code>maxValue</code> property.
	 	 *
	 	 *  @default "exceedsMaxErrorNV"
     	 */
		override public function get exceedsMaxError():String {
			return ValidatorUtil.replaceWithLabel(super.exceedsMaxError, fieldLabel);
		}
	
	    /**
     	 *  Error message when the number must be an integer, as defined 
     	 * by the <code>domain</code> property.
	 	 *
	 	 *  @default "integerError"
     	 */
		override public function get integerError():String {
			return ValidatorUtil.replaceWithLabel(super.integerError, fieldLabel);
		}
	
	
	    /**
     	 *  Error message when the value contains invalid characters.
	 	 *
	 	 *  @default "invalidCharError"
     	 */	
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
	    /**
     	 *  Error message when the value contains invalid format characters, which means that 
     	 *  it contains a digit or minus sign (-) as a separator character, 
     	 *  or it contains two or more consecutive separator characters.
	 	 *
	 	 *  @default "invalidFormatCharsError"
     	 */
		override public function get invalidFormatCharsError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidFormatCharsError, fieldLabel);
		}
	
	    /**
     	 *  Error message when the value is less than <code>minValue</code>.
	 	 *
		 *  @default "lowerThanMinError"
    	 */
		override public function get lowerThanMinError():String {
			return ValidatorUtil.replaceWithLabel(super.lowerThanMinError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the value is negative and the 
    	 *  <code>allowNegative</code> property is <code>false</code>.
		 *
		 *  @default "negativeError"
    	 */
		override public function get negativeError():String {
			return ValidatorUtil.replaceWithLabel(super.negativeError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the value has a precision that exceeds the value defined 
    	 *  by the precision property.
		 *
		 *  @default "precisionError"
    	 */
		override public function get precisionError():String {
			return ValidatorUtil.replaceWithLabel(super.precisionError, fieldLabel);
		}
	
	
	    /**
    	 *  Error message when the thousands separator is in the wrong location.
		 *
		 *  @default "separationError"
    	 */
		override public function get separationError():String {
			return ValidatorUtil.replaceWithLabel(super.separationError, fieldLabel);
		}	
	}
}