package gov.va.med.fw.validators { 
	import mx.validators.EmailValidator;
	import mx.utils.StringUtil;
	import mx.validators.Validator;
    import mx.validators.ValidationResult;
    import mx.controls.Alert;

	/**
	*	Supports both generic email addresses and domain specific e-mail addresses
	*/
	
	[ResourceBundle("validators")]
	public class CustomEmailValidator extends CustomValidator {
				
		public static const EMAIL_REGEX_DEFAULT : RegExp = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
		public static const EMAIL_REGEX_VA : RegExp = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)*VA\.GOV$/i;
		public static const EMAIL_REGEX_GOV : RegExp = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)*GOV$/i;
		public static const EMAIL_REGEX_MIL : RegExp = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)*MIL$/i;
		
		private var results:Array = null;
		private var invalidError:String = "{fieldLabel} is an invalid Email address.";
		private var govEmailAddress:Boolean = false;
		private var vaEmailAddress:Boolean = true;		 
		
		public function CustomEmailValidator() {
			super();
		}
		
		/**
		*	Override the method to validate multiple e-mail addresses
		*/
		override protected function doValidation(value:Object):Array
		{
			//do the default validation
			results = [];
			results = super.doValidation(value);
			if (results.length > 0) {
				results;
			}
			
			//convert to a string for validation string
			var emailAddress:String = value as String;
			
			if (emailAddress != null || emailAddress.length > 0) {
			
				//spilt by , as mulitple addresses can be entered in line
				var addresses:Array = emailAddress.split(",");
				
				//validate each email address
				for (var i:int=0; i<addresses.length; i++) {
					var address:String = addresses[i] as String;
					if (address.length > 0) {
						if (!isValidEmail(address, govEmailAddress, vaEmailAddress)) {
							results.push(new ValidationResult(true, null, null, invalidEmailError));
						} 
					}
				}
			}
			
			return results;
		}
		
		/**
     	 *  Error message when the email address is invalid
     	 *  @default requiredFieldError={fieldLabel} email address is inavlid.
     	 */
		public function get invalidEmailError():String {
			return ValidatorUtil.replaceWithLabel(this.invalidError, fieldLabel);
		}
		public function set invalidEmailError(invalidEmailError:String):void {
			if (invalidEmailError != null && invalidEmailError.length > 0) {
				this.invalidError=invalidEmailError;
			}
		}		
				
		public function get vaAddress():Boolean {
			return vaEmailAddress;
		}	
					
		public function set vaAddress(va:Boolean):void {
			vaEmailAddress = va;
		}
		
		public function get govAddress():Boolean {
			return govEmailAddress;
		}		
				
		public function set govAddress(gov:Boolean):void {
			govEmailAddress = gov;
		}
		
		public static function isValidEmail(email:String, govEmailAddress:Boolean, vaEmailAddress:Boolean) : Boolean{
			//convert to upppercase and validate
			var emailAddress:String = StringUtil.trim(email.toUpperCase());
			if(govEmailAddress) {
				vaEmailAddress = false;
			}
			if(govEmailAddress) { 
				return (Boolean(emailAddress.match(EMAIL_REGEX_GOV)) || Boolean(emailAddress.match(EMAIL_REGEX_MIL)));
			} else if (vaEmailAddress) {
            	return Boolean(emailAddress.match(EMAIL_REGEX_VA));
            }else {
            	return Boolean(emailAddress.match(EMAIL_REGEX_DEFAULT));
            }
        }
	}
}