package gov.va.med.fw.validators {
	import mx.resources.ResourceManager;
	import mx.validators.DateValidator;
	import mx.validators.ValidationResult;
	
	[ResourceBundle("validators")]
	public class CustomDateValidator extends DateValidator {
		
		public function CustomDateValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		//Use the following variables when field must be greater than or less than field2
		private var _field2Label:String;
		private var _field2:Date;
		private var _mustBeGreaterThanField2:Boolean = false;
		private var _canBeEqual:Boolean = false;
		private var _timeField:String;
		
		public var allowFuture:String = 'false';
		public var allowPast:String = 'true';
		public var allowTodayAndFuture:String = 'true';
				
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/** 
	 	 *  Error message when the <code>inputFormat</code> property
		 *  is not in the correct format.
		 *
		 *  @default "formatError" 
		 */
		override public function get formatError():String {
			return ValidatorUtil.replaceWithLabel(super.formatError, fieldLabel);
		}
	
		/** 
		 *  Error message when there are invalid characters in the date.
		 *
		 *  @default "invalidCharErrorDV"
		 */
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
		/** 
		 *  Error message when the day is invalid.
		 *
		 *  @default "wrongDayError" 
		 */
		override public function get wrongDayError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongDayError, fieldLabel);
		}	
	
		/** 
		 *  Error message when the length of the date
		 *  doesn't match that of the <code>inputFormat</code> property.
		 *
		 *  @default "TwrongLengthErrorDV" 
		 */
		override public function get wrongLengthError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongLengthError, fieldLabel);
		}

		/** 
		 *  Error message when the month is invalid.
		 *
		 *  @default "wrongMonthError"
	 	 */
		override public function get wrongMonthError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongMonthError, fieldLabel);
		}
	
		/** 
		 *  Error message when the year is invalid.
		 *
		 *  @default "wrongYearError"
		 */	
		override public function get wrongYearError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongYearError, fieldLabel);
		}
		
		override protected function doValidation(value:Object) : Array {
			var results:Array = super.doValidation(value);
			
			if (results == null || results.length == 0) {
				var valueDate:Date = new Date(value);
				
				if (allowFuture == null || allowFuture == 'false') {
					if (valueDate > new Date()) {
						var futureDateError:String = ResourceManager.getInstance().getString("validators", "futureDateError");
						futureDateError = ValidatorUtil.replaceWithLabel(futureDateError, fieldLabel);
						results.push(new ValidationResult(true, value.toString(), "futureDate", futureDateError));
					}
				}
				
				if (allowTodayAndFuture == null || allowTodayAndFuture == 'false') {
					if (valueDate > getYesterday()) {
						var todayAndFutureDateError:String = ResourceManager.getInstance().getString("validators", "todayAndFutureDateError");
						todayAndFutureDateError = ValidatorUtil.replaceWithLabel(todayAndFutureDateError, fieldLabel);
						results.push(new ValidationResult(true, value.toString(), "todayAndFutureDate", todayAndFutureDateError));
					}
				}
				
				if (allowPast == null || allowPast == 'false') {
					var now:Date = new Date();
					var startOfToday:Date = new Date(now.getFullYear(), now.getMonth(), now.getDate());
					
					if (valueDate < startOfToday) {
						var pastDateError:String = ResourceManager.getInstance().getString("validators", "pastDateError");
						pastDateError = ValidatorUtil.replaceWithLabel(pastDateError, fieldLabel);
						results.push(new ValidationResult(true, value.toString(), "pastDate", pastDateError));
					}
				}
				
				//sql server datetime component can't be less than 01/01/1753
				if (valueDate < new Date("01/01/1753")) {
					var sqlDateError:String = ResourceManager.getInstance().getString("validators","sqlServerPastDateError");
					sqlDateError = ValidatorUtil.replaceWithLabel(sqlDateError, fieldLabel)
				    results.push(new ValidationResult(true,value.toString,"",sqlDateError));
				} 

				
				if (_field2 != null && value != null && value != "")
					compareDates(value, results);
			}
			return results;
	    }
	    
	    /*
	     * Compare 2 dates based on variable values. Include time in the comparison if the 
	     * _timeField variable is set and the dates are the same, otherwise clear the time values.
	     */
	    private function compareDates(value:Object, results:Array):void {
	    	var valueDate2:Date = new Date(value);
	    	var tempField2:Date = new Date(_field2.valueOf());
	    	
	    	valueDate2.setSeconds(0);
	    	tempField2.setSeconds(0);
	    	
			valueDate2.setHours(0);
			valueDate2.setMinutes(0);
            tempField2.setHours(0);
			tempField2.setMinutes(0);
			
			//only add the time if the base dates are the same	
			if (_timeField != null && _timeField != "" && valueDate2.day == tempField2.day && 
			      valueDate2.month == tempField2.month && valueDate2.fullYear == tempField2.fullYear){ 
			    //reset tempField2 to include time except for seconds
			    tempField2 = new Date(_field2.valueOf());
			    tempField2.setSeconds(0);
			    
				if (_timeField.indexOf(":") > 0) {
					valueDate2.setMinutes(_timeField.substring(0,_timeField.indexOf(":")));
					valueDate2.setHours(_timeField.substr(_timeField.indexOf(":"),_timeField.length));
				} else {
					valueDate2.setHours(_timeField.substr(0,2));
					valueDate2.setMinutes(_timeField.substr(2,_timeField.length));
				}
			}
			
			if (_mustBeGreaterThanField2 && !canBeEqual && valueDate2 <= tempField2) {
				var dateCompareError:String = fieldLabel + " must be after the " + field2Label + ".";
				results.push(new ValidationResult(true,value.toString,"",dateCompareError));
			} else if (_mustBeGreaterThanField2 && canBeEqual && valueDate2 < tempField2 ) {
				var dateCompareError1:String = fieldLabel + " must be equal to or after the " + field2Label + ".";
				results.push(new ValidationResult(true,value.toString,"",dateCompareError1));
			} else if (!_mustBeGreaterThanField2 && !canBeEqual && valueDate2 >= tempField2) {
				var dateCompareError2:String = fieldLabel + " must be before the " + field2Label + ".";
				results.push(new ValidationResult(true,value.toString,"",dateCompareError2));
			}  else if (!_mustBeGreaterThanField2 && canBeEqual && valueDate2 > tempField2) {
				var dateCompareError3:String = fieldLabel + " must be equal to or before the " + field2Label + ".";
				results.push(new ValidationResult(true,value.toString,"",dateCompareError3));
			}
	    }
	
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
		 * Getter method for field2Label parameter.
		 */
		public function get field2Label():String {
			return this._field2Label;
		}
		
		/**
		 * Setter method for field2Label paremeter.
		 */
		public function set field2Label(field2Label:String):void {
			this._field2Label = field2Label;
		}
		
		/**
		 * Getter method for field2 parameter.
		 */
		public function get field2():Date {
			return this._field2;
		}
		
		/**
		 * Setter method for field2 paremeter.
		 */
		public function set field2(field2:Date):void {
			this._field2 = field2;
		}
		
		/**
		 * Getter method for mustBeGreaterThanField2 parameter.
		 */
		public function get mustBeGreaterThanField2():Boolean {
			return this._mustBeGreaterThanField2;
		}
		
		/**
		 * Setter method for mustBeGreaterThanField2 paremeter.
		 */
		public function set mustBeGreaterThanField2(mustBeGreaterThanField2:Boolean):void {
			this._mustBeGreaterThanField2 = mustBeGreaterThanField2;
		}
		
		/**
		 * Getter method for canBeEqual parameter.
		 */
		public function get canBeEqual():Boolean {
			return this._canBeEqual;
		}
		
		/**
		 * Setter method for canBeEqual paremeter.
		 */
		public function set canBeEqual(canBeEqual:Boolean):void {
			this._canBeEqual = canBeEqual;
		}
		
		/**
		 * Getter method for timeField parameter.
		 */
		public function get timeField():String {
			return this._timeField;
		}
		
		/**
		 * Setter method for timeField paremeter.
		 */
		public function set timeField(timeField:String):void {
			this._timeField = timeField;
		}
		
		public function getYesterday():Date {
			var yesterday:Date = new Date();
	        	var today:Date = new Date();
	        	
	        	yesterday.hours = int(today.getHours())-24;
	        	return yesterday;
		}
	}
}