package gov.va.med.fw.validators {
	import mx.validators.CurrencyValidator;

	[ResourceBundle("validators")]
	public class CustomCurrencyValidator extends CurrencyValidator {
		
		public function CustomCurrencyValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/**
    	 *  Error message when the currency symbol, defined by <code>currencySymbol</code>,
    	 *  is in the wrong location.
		 *  
		 *  @default "currencySymbolError"
    	 */
		override public function get currencySymbolError():String {
			return ValidatorUtil.replaceWithLabel(super.currencySymbolError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the decimal separator character occurs more than once.
		 *  
		 *  @default "decimalPointCountError"
    	 */
		override public function get decimalPointCountError():String {
			return ValidatorUtil.replaceWithLabel(super.decimalPointCountError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the value is greater than <code>maxValue</code>.
		 *  
		 *  @default "lowerThanMinError"
    	 */
		override public function get exceedsMaxError():String {
			return ValidatorUtil.replaceWithLabel(super.exceedsMaxError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the currency contains invalid characters.
		 *  
		 *  @default "invalidCharError"
    	 */	
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the value contains an invalid formatting character.
		 *  
		 *  @default "invalidFormatCharsError"
    	 */
		override public function get invalidFormatCharsError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidFormatCharsError, fieldLabel);
		}
	
	   /**
    	 *  Error message when the value is less than <code>minValue</code>.
		 *  
		 *  @default "lowerThanMinError"
    	 */
		override public function get lowerThanMinError():String {
			return ValidatorUtil.replaceWithLabel(super.lowerThanMinError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the value is negative and
    	 *  the <code>allowNegative</code> property is <code>false</code>.
		 *  
		 *  @default "negativeError"
    	 */
		override public function get negativeError():String {
			return ValidatorUtil.replaceWithLabel(super.negativeError, fieldLabel);
		}
	
	    /**
     	 *  Error message when the value has a precision that exceeds the value
    	 *  defined by the <code>precision</code> property.
		 *  
		 *  @default "precisionError"
    	 */
		override public function get precisionError():String {
			return ValidatorUtil.replaceWithLabel(super.precisionError, fieldLabel);
		}
	
	    /**
    	 *  Error message when the thousands separator is incorrectly placed.
		 *  
		 *  @default "separationError"
    	 */
		override public function get separationError():String {
			return ValidatorUtil.replaceWithLabel(super.separationError, fieldLabel);
		}
	}
}