package gov.va.med.fw.validators {
	import mx.validators.CreditCardValidator;

	[ResourceBundle("validators")]
	public class CustomCreditCardValidator extends CreditCardValidator {
		
		public function CustomCreditCardValidator() {
			super();
		}
		
		private var _fieldLabel:String;
		
		/**
		 * Getter method for fieldLabel parameter.
		 */
		public function get fieldLabel():String {
			return this._fieldLabel;
		}
		
		/**
		 * Setter method for fieldLabel paremeter.
		 */
		public function set fieldLabel(fieldLabel:String):void {
			this._fieldLabel = fieldLabel;
		}
		
		/**
     	 *  Error message when a value is missing and the 
     	 *  <code>required</code> property is <code>true</code>. 
     	 *  
     	 *  @default requiredFieldError={fieldLabel} is required.
     	 */
		override public function get requiredFieldError():String {
			return ValidatorUtil.replaceWithLabel(super.requiredFieldError, fieldLabel);
		}
		
		/** 
		 *  Error message when the <code>cardNumber</code> field contains invalid characters.
		 *
		 *  @default "invalidCharError"
		 */
		override public function get invalidCharError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidCharError, fieldLabel);
		}
	
		/** 
		 *  Error message when the credit card number is invalid.
		 *
		 *  @default "invalidNumberError"
		 */
		override public function get invalidNumberError():String {
			return ValidatorUtil.replaceWithLabel(super.invalidNumberError, fieldLabel);
		}
	
		/** 
		 *  Error message when the <code>cardNumber</code> field is empty.
		 *
		 *  @default "noNumError"
		 */
		override public function get noNumError():String {
			return ValidatorUtil.replaceWithLabel(super.noNumError, fieldLabel);
		}
	
		/** 
		 *  Error message when the <code>cardType</code> field is blank.
		 *
		 *  @default "No credit card type is specified or the type is not valid."
		 */
		override public function get noTypeError():String {
			return ValidatorUtil.replaceWithLabel(super.noTypeError, fieldLabel);
		}
	
		/**
		 *  Error message when the <code>cardNumber</code> field contains the wrong
		 *  number of digits for the specified credit card type.
		 *
		 *  @default "wrongLengthError" 
		 */
		override public function get wrongLengthError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongLengthError, fieldLabel);
		}
	
		/** 
		 *  Error message the <code>cardType</code> field contains an invalid credit card type. 
		 *  You should use the predefined constants for the <code>cardType</code> field:
		 *  <code>CreditCardValidatorCardType.MASTER_CARD</code>,
		 *  <code>CreditCardValidatorCardType.VISA</code>, 
		 *  <code>CreditCardValidatorCardType.AMERICAN_EXPRESS</code>,
		 *  <code>CreditCardValidatorCardType.DISCOVER</code>, or 
		 *  <code>CreditCardValidatorCardType.DINERS_CLUB</code>.
		 *
		 *  @default "wrongTypeError"
		 */
		override public function get wrongTypeError():String {
			return ValidatorUtil.replaceWithLabel(super.wrongTypeError, fieldLabel);
		}	
	}
}