
package gov.va.med.fw.utils
{
	import flash.events.EventDispatcher;
	import flash.utils.describeType;
	
	public dynamic class EventDispatcherProxy
	{
		private var _ed:EventDispatcher;
		private var _map:Object = new Object();
		 
		public function EventDispatcherProxy(ed:EventDispatcher)
		{
			super();
			this._ed=ed;
		}
			
        public function addEventListener(type:String, listener:Function, listenerName:String, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = true):void
        {
        	addToMap(type, listener, listenerName, useCapture);		
        	_ed.addEventListener(type, listener, useCapture, priority, useWeakReference);
        }
        
        public function removeEventListener(type:String, listener:Function, listenerName:String, useCapture:Boolean = false):void
        {
        	_ed.removeEventListener(type, listener, useCapture);
        	removeFromMap(type, listener, listenerName, useCapture);
        }
        
        public function removeAllEventListenes():void
        {
        	for each (var obj:Object in _map)
        	{
        		if (obj is Array)
        		{
        			var arr:Array = obj as Array;
        			removeEventListener(arr[0] as String, arr[1] as Function, arr[2] as String, arr[3] as Boolean);
        		}
        	}
        }
        
        private function constructKey(type:String, listenerName:String, useCapture:Boolean):String
        {	
			var result:String = "eventListener^"+type+"^"+listenerName+"^"+useCapture.toString();
        	return result;
        }
        
        private function addToMap(type:String, listener:Function, listenerName:String, useCapture:Boolean):void
 	 	{
 	 		var key:String = constructKey(type, listenerName, useCapture);
 	 		var value:Object = [type, listener, listenerName, useCapture];
 	 		_map[key]=value;
 	 	}
 	 	
 	 	private function removeFromMap(type:String, listener:Function, listenerName:String, useCapture:Boolean):void
 	 	{
 	 		var key:String = constructKey(type, listenerName, useCapture);
 	 		if (_map.hasOwnProperty(key))
 	 			delete(_map[key]);
 	 	}
	}
}