package gov.va.med.fw.utils {
	
	public class DateUtils {
		
		private static const millisecondsPerDay:int = 1000 * 60 * 60 * 24;
		
		public function DateUtils() {
			super();
		}
		
		/**
		 * Converts the specified Date to a new Date whose printed value reflects
		 * the same instant in time, but in the specified User's time zone. The
		 * returned value should only be used for printing, but never for calculations,
		 * since its internal time value is incorrect. CPB
		 */
		public static function convertDateToUserTimeZone(d:Date, userTimeZoneOffsetMillis:int):Date {
			var offsetWebBrowser:int = new Date().getTimezoneOffset() * 60 * 1000;
			var result:Date = new Date(d.getTime() + offsetWebBrowser + userTimeZoneOffsetMillis);
			return result;
		}
		
		/**
		 * Converts the specified Date, likely one entered by the user and having an 
		 * implied time zone of that of the user, to a new Date whose
		 * internal millisecond value is correct and whose time zone is that of the
		 * local web browser. CPB
		 */
		public static function convertDateFromUserTimeZone(d:Date, userTimeZoneOffsetMillis:int):Date {
			var offsetWebBrowser:int = new Date().getTimezoneOffset() * 60 * 1000;
			var result:Date = new Date(d.getTime() - offsetWebBrowser - userTimeZoneOffsetMillis);
			return result;
		}
		
		
		/**
		 * Converts the specified Date, unsing the given offset in millis, to a new Date whose
		 * internal millisecond value is correct and whose time zone is that of the
		 * local web browser.
		 */
		public static function convertDateFromGivenOffsetInMillis(d:Date, offset:Number):Date {
			var offsetWebBrowser:int = new Date().getTimezoneOffset() * 60 * 1000;
			var result:Date = new Date(d.getTime() - offsetWebBrowser - offset);
			return result;
		}

		
		/**
		 * Converts the specified Date, with a give timezone, to a new Date whose
		 * internal millisecond value is correct and whose time zone is that of the
		 * local web browser.
		 */
		public static function convertDateFromGivenTimeZone(d:Date):Date {
			var offsetGivenZone:int = d.timezoneOffset * 60 * 1000;
			var offsetWebBrowser:int = new Date().getTimezoneOffset() * 60 * 1000;
			var result:Date = new Date(d.getTime() - offsetWebBrowser + offsetGivenZone);
			return result;
		}
	
		public static function getElapsedBusinessDays(start:Date, end:Date):int {
			
			var numberOfDays:int = 0;
			
			while (start < end && start != null && end != null ) {
				
				//increment date by a day
				start.setTime(start.getTime() + millisecondsPerDay);
				
				//if day is between monday and friday, add one day
				if (start.day >= 1 && start.day <=5) {
					numberOfDays ++
				}
			}
			return numberOfDays;
		}
		
		public static function forwardBusinessDays(start:Date, businessDays:int):Date {
			
			var forwarded:Date = start;
			
			if( start != null && businessDays > 0 ) {
				var i:int;
				for( i=0; i<businessDays; i++ ) {
					
					// Not Sunday (0) and Saturday (6)
					if( forwarded.day == 0 || forwarded.day == 6 ) {
						businessDays ++
					}
					//increment date by a day
					forwarded.setTime(forwarded.getTime() + millisecondsPerDay);
					
				}
			}
			return forwarded;
		}
	}
}