package gov.va.med.fw.rpc
{
	import gov.va.med.fw.rpc.RemoteCallModelLocator;
	
	import mx.core.EventPriority;
	import mx.messaging.messages.RemotingMessage;
	import mx.rpc.AsyncToken;
	import mx.rpc.Responder;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.InvokeEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;

	public class CustomRemoteObject extends mx.rpc.remoting.mxml.RemoteObject
	{
		public var blockUI:Boolean=true;
		
		public function CustomRemoteObject(destination:String=null)
		{
			super(destination);
			this.concurrency="single";
			this.showBusyCursor=true;
			addEventListener(FaultEvent.FAULT, _onFault, false, EventPriority.CURSOR_MANAGEMENT);
			addEventListener(ResultEvent.RESULT, _onResult, false, EventPriority.CURSOR_MANAGEMENT);
			addEventListener(InvokeEvent.INVOKE, _onInvoke, false, EventPriority.CURSOR_MANAGEMENT);
		}
		
		private function _onInvoke(event:InvokeEvent):void
		{
			if (blockUI)
			{
				RemoteCallModelLocator.setBusy((event.message as RemotingMessage).operation, this.concurrency!="last");
			}
		}
		
		private function _onFault(event:FaultEvent):void
		{
			if (blockUI)
			{
				RemoteCallModelLocator.removeBusy((event.token.message as RemotingMessage).operation);
			}
		}
		
		private function _onResult(event:ResultEvent):void
		{
			/* TODO: below is not working
			var perfMetrics:MessagePerformanceUtils = new MessagePerformanceUtils(event.message);
			trace(perfMetrics.prettyPrint()); */
			
			if (blockUI)
			{
				RemoteCallModelLocator.removeBusy((event.token.message as RemotingMessage).operation);
			}
		}
		
		public function invokeRemote(functionName:String, args:Array, responders:Array):*
		{
			//return this[functionName](args);
			var at:AsyncToken = getOperation(functionName).send.apply(null, args);
			for each(var r:Responder in responders)
			{
				if (r!=null && (r is Responder))
					at.addResponder(r);
			}		
		}
		
		public function invokeRemoteSimple(functionName:String, args:Array, resultHandler:Function=null, faultHandler:Function=null):*
		{
			//return this[functionName](args);
			var at:AsyncToken = getOperation(functionName).send.apply(null, args);
			var r:Responder = new Responder(resultHandler, faultHandler);
			at.addResponder(r);		
		}
	}
}