package gov.va.med.fw.model {
	import gov.va.med.ccht.ui.common.model.IEquals;
	import gov.va.med.ccht.ui.common.model.IMatch;
	
	[Bindable]
	[RemoteClass(alias="gov.va.med.fw.ui.model.TermType")]
	public dynamic class TermType implements IEquals, IMatch{
	
		public var label:String;
		public var value:String;
		public var enabled:Boolean = true;

		public function TermType() {}
				
		//combobox expects a data function
		public function get data():String
		{
			return value;
		}
		
		public function equals(object:Object):Boolean {
			if (!object) return false;
			if (object is TermType) {
				var other:TermType = object as TermType;
				return (value == other.value)
			}
			return false;
		}
		
		public function match(object:Object):Boolean {
			return equals(object);
		}
		
		public static function create(label:String, value:String):TermType {
			var newType:TermType = new TermType();
			newType.label = label;
			newType.value = value;
			return newType;
		}
	}
}