package gov.va.med.fw.controls {
    
    import mx.controls.listClasses.IListItemRenderer;
    import mx.core.IFactory;

    public class SummaryColumn implements IFooterDataGridColumn {
        public static const SUM:String = 'sum';
         
        private var _dataColumn:Object;
        
        [Bindable] public var footer:SummaryFooter;
        [Bindable] public var labelFunction:Function;
        [Bindable] public var label:String;
        [Bindable] public var itemRenderer:IFactory;
        [Bindable] public var column:Object;
        [Bindable] public var renderer:IListItemRenderer;
        [Bindable] public var useColumnItemRenderer:Boolean = true;
        
        public var precision:int = 0;
        
        private var _operation:String;

        // dataColumn is the one that feeds the data
        public function set dataColumn(value:Object):void {
            _dataColumn = value;
        }

        public function get dataColumn():Object {
            return (_dataColumn) ? _dataColumn : column;
        }
        
        private function sum(col:Object):Number {
            var total:Number = 0;
            for each (var row:Object in dataProvider) {
                total += row[col.dataField];
            }
                
            return total;
        }
        
        public function set operation(value:String):void {
            _operation = value;
            labelFunction = defaultLabelFunction;
        }
        
        private function defaultLabelFunction(col:Object):String {
            var value:Number = 0;
            
            switch (_operation) {
                case SUM:
                    value = sum(col);
                    break;
           }
            
            var label:String = (value) ? value.toFixed(precision) : '';
            
            return label.replace(/\.00/,'');
        }
        
        public function get dataProvider():Object {
            return footer.dataProvider;
        }
    }
}