package gov.va.med.fw.controls
{
	import flash.events.ContextMenuEvent;
	import flash.events.EventDispatcher;
	import flash.events.MouseEvent;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	
	import mx.core.Container;
	import mx.core.EventPriority;
	import mx.core.IMXMLObject;
	import mx.core.UIComponent;
	import mx.core.mx_internal;
	
	use namespace mx_internal;
	
	public class ContextMenuBuilder implements IMXMLObject
	{
		mx_internal var document:Object;
    	mx_internal var id:String;
		
		private var _watchedComponent:UIComponent;
		private var _controls:Array;
		private var _menu:ContextMenu = new ContextMenu();
			
		private function menuItemSelect(event:Object):void
		{
			var cmi:ContextMenuItem = ((event as ContextMenuEvent).target as ContextMenuItem);
			if(cmi==null || !cmi.enabled)
				return;
			for each(var obj:Object in _controls)
			{
				if(obj is Button)
				{
					var btn:Button = obj as Button;
					if(btn.visible && btn.enabled && (btn.label == cmi.caption))
					{
						btn.dispatchEvent(new MouseEvent(MouseEvent.CLICK));
						return;
					}
				}
			}
		}
		
		private function destroyMenuItems():void
		{
			for each(var ci:ContextMenuItem in _menu.customItems)
			{
				ci.removeEventListener(ContextMenuEvent.MENU_ITEM_SELECT, menuItemSelect);
			}
			_menu.customItems=[];	
		}
		
		private function buildMenuItems():void
		{
			destroyMenuItems();
			if(_controls != null && _controls.length>0 && _watchedComponent != null)
			{
				_menu.hideBuiltInItems();
				_watchedComponent.stage.showDefaultContextMenu = false;
				for each(var obj:Object in _controls)
				{
					if (obj==null)
						continue;
					if(obj is Button)
					{
						var btn:Button = obj as Button;
						if(btn.visible && btn.enabled)
						{
							var cmi:ContextMenuItem = new ContextMenuItem(btn.label, false, true, btn.visible);
							cmi.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, menuItemSelect, false, 0, true);
							_menu.customItems.push(cmi);
						}
					}
				}
			}
			if(_watchedComponent != null) {
				_watchedComponent.contextMenu = _menu;
			}
		}
			
		public function get watchedComponent():UIComponent
		{
			return _watchedComponent;	
		}
		
		public function set watchedComponent(component:UIComponent):void
		{
			if (_watchedComponent == component)
				return;
			if (_watchedComponent != null)
			{
				_watchedComponent.contextMenu = null;	
			}
			_watchedComponent = component;
			if (_watchedComponent != null)
			{
				_watchedComponent.contextMenu = _menu;	
			}		
		}
		
		public function get controls():Array
		{
			return _controls;	
		}
		
		public function set controls(arr:Array):void
		{
			if (_watchedComponent != null)
				_watchedComponent.contextMenu = null;
			_controls = arr;
			buildMenuItems();
			if(_watchedComponent != null)
			{
				_watchedComponent.contextMenu = _menu;
			}
		}
		
		public function update():void
		{
			buildMenuItems();
		}
		
		public function initialized(document:Object, id:String):void
		{
			this.document = document;
        	this.id = id;
		}
	}
	
}