import gov.va.med.ccht.ui.common.view.DataGridPanel;
import gov.va.med.ccht.ui.inventory.view.DeviceStatusByVendorGrid;
import gov.va.med.fw.controls.AccessibleAdvancedDataGrid;

import mx.controls.Spacer;

import spark.layouts.RowAlign;

/**
 * Contains Reusable report functions
 **/ 
public function createReportDataView(reportDataViewContainer:VGroup, report:Report):void {
	reportDataViewContainer.visible = false;
	reportDataViewContainer.removeAllElements();
	var repDataContainer:AccessibleAdvancedDataGrid = null;
	var rs:ReportSetup = report.reportSetup;
	var reportParameters:ReportParameters = report.reportSetup.reportParameters;
	var reportHeader:ReportHeader = new ReportHeader();
	var reportFooter:ReportFooter = new ReportFooter();
	reportHeader.reportSetup = report.reportSetup;
	reportFooter.reportSetup = report.reportSetup;
	reportDataViewContainer.addElement(reportHeader);	
	
	var variablePageSize:Boolean = true;
	
	if (report.reportData == null || report.reportData.length == 0) {
		var reportNoDataFoundSection:ReportNoDataFoundSection = new ReportNoDataFoundSection();
		reportDataViewContainer.addElement(reportNoDataFoundSection);	
	}
	else {		
		//Device Inventory Report
		if (rs.standardReport.value == "DI1") {
			if (reportParameters.reportSummaryType.value == "National") {
				if (reportParameters.subTotalType.value == "Vendor") {
					repDataContainer = new NationalDIByVendorGrid();	
					(repDataContainer as NationalDIByVendorGrid).dataCollection = report.reportData as ArrayCollection;	
					variablePageSize = false;
				}else if (reportParameters.subTotalType.value == "Device"){
					repDataContainer = new NationalDIByDeviceGrid();	
					repDataContainer.dataProvider = report.reportData as ArrayCollection;								
				}
			}
			else if (reportParameters.reportSummaryType.value == "VISN") {
				if (reportParameters.subTotalType.value == "Vendor") {
					repDataContainer = new VisnDIByVendorGrid();		
					(repDataContainer as VisnDIByVendorGrid).dataCollection = report.reportData as ArrayCollection;		
					variablePageSize = false;
				}else if (reportParameters.subTotalType.value == "Device"){
					repDataContainer = new VisnDIByDeviceGrid();	
					repDataContainer.dataProvider = report.reportData as ArrayCollection;								
				}
			}
			else if (reportParameters.reportSummaryType.value == "Facility") {
				if (reportParameters.subTotalType.value == "Vendor") {
					repDataContainer = new FacilityDIByVendorGrid();	
					(repDataContainer as FacilityDIByVendorGrid).dataCollection = report.reportData as ArrayCollection;		
					variablePageSize = false;
				}else if (reportParameters.subTotalType.value == "Device"){
					repDataContainer = new FacilityDIByDeviceGrid();
					repDataContainer.dataProvider = report.reportData as ArrayCollection;									
				}
			}									
		}
			//Device Status Report
		else if (rs.standardReport.value == "DI2") {
			if (reportParameters.subTotalType.value == "Vendor") {
				var deviceStatusByVendorGrid:DeviceStatusByVendorGrid = new DeviceStatusByVendorGrid();
				repDataContainer = deviceStatusByVendorGrid;
				//set the visibility flags
				if (reportParameters.reportSummaryType.value == "National") {
					deviceStatusByVendorGrid.location = false;
				}else {
					if (reportParameters.reportSummaryType.value == "VISN")
						deviceStatusByVendorGrid.locationTitle="VISN";
					else if (reportParameters.reportSummaryType.value == "Facility")
						deviceStatusByVendorGrid.locationTitle="Facility";
				}
				//selected status flags
				if (reportParameters.deviceStatuses != null && reportParameters.deviceStatuses.length > 0) {
					for (var i:int=0; i<reportParameters.deviceStatuses.length; i++) {
						var t:TermType = reportParameters.deviceStatuses.getItemAt(i) as TermType;							
						if (t.value == 'ASN') deviceStatusByVendorGrid.assigned = true;
						else if(t.value == 'AVL') deviceStatusByVendorGrid.available = true;								
						else if (t.value == 'REF') deviceStatusByVendorGrid.refurbish = true;
						else if (t.value == 'RPR') deviceStatusByVendorGrid.repair = true;
						else if (t.value == 'DEC') deviceStatusByVendorGrid.decommissioned = true;
					}
					if (reportParameters.deviceStatuses.length > 1) {
						deviceStatusByVendorGrid.total = true;
					}
				}
			} else {
				var deviceStatusByDeviceGrid:DeviceStatusByDeviceGrid = new DeviceStatusByDeviceGrid();
				repDataContainer = deviceStatusByDeviceGrid;
								
				//set the visibility flags
				if (reportParameters.reportSummaryType.value == "National") {
					deviceStatusByDeviceGrid.location = false;
				}else {
					if (reportParameters.reportSummaryType.value == "VISN")
						deviceStatusByDeviceGrid.locationTitle="VISN";
					else if (reportParameters.reportSummaryType.value == "Facility")
						deviceStatusByDeviceGrid.locationTitle="Facility";
				}
				//selected status flags
				if (reportParameters.deviceStatuses != null && reportParameters.deviceStatuses.length > 0) {
					for (var j:int=0; j<reportParameters.deviceStatuses.length; j++) {
						var ds:TermType = reportParameters.deviceStatuses.getItemAt(j) as TermType;							
						if (ds.value == 'ASN') deviceStatusByDeviceGrid.assigned = true;
						else if(ds.value == 'AVL') deviceStatusByDeviceGrid.available = true;								
						else if (ds.value == 'REF') deviceStatusByDeviceGrid.refurbish = true;
						else if (ds.value == 'RPR') deviceStatusByDeviceGrid.repair = true;
						else if (ds.value == 'DEC') deviceStatusByDeviceGrid.decommissioned = true;
					}
					if (reportParameters.deviceStatuses.length > 1) {
						deviceStatusByDeviceGrid.total = true;
					}
				}
			}
			repDataContainer.dataProvider = report.reportData as ArrayCollection;	
		}
			//Device Failure Report
		else if (rs.standardReport.value == "DI3") {					
			repDataContainer = new DeviceFailureReportGrid();
			var deviceFailureReportGrid:DeviceFailureReportGrid = repDataContainer as DeviceFailureReportGrid;
			//set the visibility flags
			if (reportParameters.reportSummaryType.value == "National") {
				deviceFailureReportGrid.visn = false;
				deviceFailureReportGrid.facility = false;
			}else if (reportParameters.reportSummaryType.value == "VISN") {
				deviceFailureReportGrid.visn = true;
				deviceFailureReportGrid.facility = false;
			} else if (reportParameters.reportSummaryType.value == "Facility") {
				deviceFailureReportGrid.visn = true;
				deviceFailureReportGrid.facility = true;
			}
			
			repDataContainer.dataProvider = report.reportData as ArrayCollection;	
		} //Device Shortage Report
		else if (rs.standardReport.value == "DI4") {					
			repDataContainer = new DeviceShortageReportGrid();
			var deviceShortageReportGrid:DeviceShortageReportGrid = repDataContainer as DeviceShortageReportGrid;	
			//set the visibility flags
			if (reportParameters.reportSummaryType.value == "National") {
				deviceShortageReportGrid.visn = false;
				deviceShortageReportGrid.facility = false;
			}else if (reportParameters.reportSummaryType.value == "VISN") {
				deviceShortageReportGrid.visn = true;
				deviceShortageReportGrid.facility = false;
			} else if (reportParameters.reportSummaryType.value == "Facility") {
				deviceShortageReportGrid.visn = true;
				deviceShortageReportGrid.facility = true;
			}						
			repDataContainer.dataProvider = report.reportData as ArrayCollection;	
		}
		
		if (repDataContainer != null) {
			var dataGridPanel:DataGridPanel = new DataGridPanel();
			dataGridPanel.variablePageSize = variablePageSize;
			//Fix the width based on the report type
			if (rs.standardReport.value == "DI2") {
				dataGridPanel.percentWidth = 100;
			}	
			else if (repDataContainer.minWidth > 0) {	
				dataGridPanel.width = repDataContainer.minWidth + 40;
			}
 			else {
				dataGridPanel.percentWidth = 70;
			}
			reportDataViewContainer.addElement(dataGridPanel);
			dataGridPanel.addElement(repDataContainer);	
			dataGridPanel.dataGrid = repDataContainer;
			if (report.reportData.length > 25) {
				repDataContainer.rowCount = 26;
			} else if (report.reportData.length > 10) {
				repDataContainer.rowCount = 11;			
			} else if (report.reportData.length > 5) {
				repDataContainer.rowCount = report.reportData.length + 1;		
			}
			else {
				repDataContainer.rowCount = 6;	
			}
			var spacer:Spacer = new Spacer();
			spacer.height = 25;
			spacer.percentWidth = 100;
			dataGridPanel.addElement(spacer);
			dataGridPanel.addElement(reportFooter);
		}
	}
	GarbageCollectorDelegate.collect();				
	reportDataViewContainer.visible = true;	
}			