package gov.va.med.ccht.ui.common.utils.excel {
	
	import com.as3xls.xls.ExcelFile;
	import com.as3xls.xls.Sheet;
	
	import flash.display.Sprite;
	import flash.net.FileReference;
	import flash.system.System;
	import flash.utils.ByteArray;
	import flash.utils.getDefinitionByName;
	
	import mx.collections.ArrayCollection;
	import mx.collections.Sort;
	import mx.collections.SortField;
	import mx.controls.Alert;
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.Application;
	import mx.core.FlexGlobals;
	import mx.core.UIComponent;
	import mx.formatters.DateFormatter;
	import mx.utils.StringUtil;
	
	import gov.va.med.ccht.ui.common.model.DMPContents;
	import gov.va.med.ccht.ui.common.model.QIR;
	import gov.va.med.ccht.ui.htreport.model.DmpReportEntry;
	import gov.va.med.ccht.ui.htreport.view.DMPReport;
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.utils.DateUtils;
	
	public class ExcelSaveAs {
		
		private var fileReference:FileReference;
	//	private var xls:Class;
		
	//	private var sheet:Sheet;
		private var dmpXLStemplate:String = "" +
			//		<Content-type: application/vnd.ms-excel;charset=utf-8>
			//		<!DOCTYPE application/vnd.ms-excel;charset=utf-8>
			//		"<!DOCTYPE application/vnd.ms-excel;charset=utf-8>" +
			"<HTML>" +
			" <head> <title>DMP Export</title> <style type=\"text/xls\"> </style><meta http-equiv='Content-Type' content='text/xls; charset=utf-8'> </head>" +
			"<body STYLE=\"background-color:transparent\">" +
			"<TABLE Border=\"0\" >" +
			"    <TR><TD></TD></TR>" +
			"    <TR><TD ColSpan=\"9\" align=\"center\"><FONT Size=\"+2\"><b><i>##TITLE##</i></b></FONT></TD></TR>" +
			"</TABLE>" +
			"<BR>" +
			"<TABLE   BORDER=\"1\">" +
			"        <TR>##HEADERS##</TR>" +
			"        ##ROWS##" +
			"</TABLE>" +
			"<BR>" +
			"<TABLE>" +
			"    <TR><TD ColSpan=\"9\" align=\"center\"><FONT Size=\"+1\"><b>End of Data</b></FONT></TD></TR>" +
			"<BR>" +
			"</TABLE>" +
			"</BODY>" +
			"</HTML>";	
		
		private var qirXLStemplate:String = "" +
			"<HTML  xmlns:v=\"urn:schemas-microsoft-com:vml\""+
					" xmlns:o=\"urn:schemas-microsoft-com:office:office\""+
					" xmlns:x=\"urn:schemas-microsoft-com:office:excel\""+
					" xmlns=\"http://www.w3.org/TR/REC-html40\">" +
			" <head> <title>QIR Export</title> <style type=\"text/xls\"> </style> <meta http-equiv='Content-Type' content='text/xls; charset=utf-8'> </head>" +
			"<body STYLE=\"background-color:transparent\">" +
			"<TABLE Border=\"0\" >" +			
			"<TR><TD align=\"Center\" valign=\"Top\"><FONT Size=\"+1\"><b><i>##DATE##</i></b></FONT></TD>" +
			"<TD align=\"Center\" valign=\"Top\"><FONT Size=\"+1\"><b><i>##TITLE##</i></b></FONT></TD></TR>" +
			"<TR><TD align=\"Center\" valign=\"top\"><FONT Size=\"0\">##VENDORLOGIC##</FONT></TD>"+
			"<TD align=\"Center\" valign=\"top\"><FONT Size=\"0\">##QIRCLOSEDLOGIC##</FONT></TD></TR>"+
			"<BR>" +
			"</TABLE>" +							
			"<TABLE   BORDER=\"0\">" +
			"        <TR STYLE=\"border-bottom:Solid 2px Black;\">##HEADERS##</TR>" +
			"        ##ROWS##" +
			"</TABLE>" +	
			"<BR>" +
			"</BODY>" +
			"</HTML>";	
		
		private var htDMPReportTemplate:String = "" +
			"<HTML>" +
			" <HEAD> <title>HT DMP Export</title> <style type=\"text/xls\"> </style> <meta http-equiv='Content-Type' content='text/xls; charset=utf-8'> </head>" +
			"<BODY STYLE=\"background-color:transparent\">" +
			"<TABLE Border=\"0\">" +
			"<TR><TD ColSpan=\"3\" align=\"Center\"><FONT Size=\"+1\"><b><i>##TITLE##</i></b></FONT></TD></TR>" +
			"<TR><TD ColSpan=\"3\" align=\"Center\"><FONT Size=\"+1\"><b><i>##REPORTTYPE##</i></b></FONT></TD></TR>" +			
			"<TR><TD ColSpan=\"3\" align=\"Center\"><FONT Size=\"+1\"><b><i>##DATE##</i></b></FONT></TD>" +
			"</TABLE>" +
			"<BR>" +
			"<TABLE   BORDER=\"0\">" +
			"        <TR STYLE=\"border-bottom:Solid 2px Black;\">##HEADERS##</TR>" +
			"        ##ROWS##" +
			"</TABLE>" +
			"<BR>" +
			"<TABLE   BORDER=\"0\">" +
			"        <TR><TD>Grand Total of responding Patients:</TD><TD align=\"Left\">##TOTALPATIENTS##</TD></TR>" +
			
			"</TABLE>" +
			"<BR>" +
			"</BODY>" +
			"</HTML>";
		
		public function ExcelSaveAs() {}

		public function exportToExcel(dataGrid:Object):void 
		{
			
			
			
			var dataProviderCollection:ArrayCollection = dataGrid.dataProvider as ArrayCollection;
			
			if(dataProviderCollection != null && dataProviderCollection.length > 0)
			{				
				if(dataProviderCollection.getItemAt(0) is DMPContents)
				{
					exportToExcelForDMP(dataGrid);
				}
				else if(dataProviderCollection.getItemAt(0) is QIR)
				{
					exportToExcelForQIR(dataGrid);
				}
				else if(dataProviderCollection.getItemAt(0) is DmpReportEntry)
				{
					exportDmpHTReport(dataGrid);
				}
			}
		}
		
		public function exportToExcelForDMP(dataGrid:Object):void 
		{
			var dataProviderCollection:ArrayCollection = dataGrid.dataProvider as ArrayCollection;
			var rowCount:int                           = dataProviderCollection.length;
			var bytes:ByteArray 					   = new ByteArray();
			var cContents:String 					   = dmpXLStemplate;
			var dmpName:String 						   = (dataGrid as DataGrid).name;
			
			var headers:Array = (dataGrid as DataGrid).columns;

			try 
			{ 

				var cHeaders:String = "";
				var cRows:String = "";
				for each ( var hName2:Object in headers ) 
				{
					var column2:DataGridColumn = (hName2 as DataGridColumn);
					var colName2:String        = column2.headerText ;
					cHeaders += "<TD><span style=\"font-weight: bold;\">" + colName2 + " " + "</span></TD>";	
				}
				cHeaders += ""
				cContents = cContents.replace( "##HEADERS##", cHeaders );
				
				var model:SimpleExcelModel = SimpleExcelModel.getInstance();
				model.fileName = "";
				
				var fieldEntry:String = "";	
				
				for( var r2:int = 0; r2 < rowCount; r2++ ) 
				{
					var record:DMPContents = dataProviderCollection.getItemAt(r2) as DMPContents ;
					cRows += "<TR>";
					fieldEntry = "";			
					fieldEntry +=  "<TD>" +record.qStmtId + "</TD>";
					//  Commented out until it has been decided how we want to handle special character issues 	
					//	var pattern:RegExp = /[^a-zA-Z0-9\x00-\x7F]/g ; 
					//	record2.qStmtIdDesc = record2.qStmtIdDesc.replace(pattern," ");					
					
					fieldEntry +=  "<TD>" +record.qStmtIdDesc+ "</TD>";
					
					if (record.qStmtId == "")
					{
						fieldEntry +=  "<TD></TD>";
					}
					else
					{
						fieldEntry +=  "<TD>" +record.freqQuestion+ "</TD>";
					}
					
					fieldEntry +=  "<TD>" +record.response+ "</TD>";
					fieldEntry +=  "<TD>" +record.alertStatus+ "</TD>";
					fieldEntry +=  "<TD>" +record.feedbackEdu+ "</TD>";
					fieldEntry +=  "<TD>" +record.gotoValue+ "</TD>";
					fieldEntry +=  "<TD>" +record.vendorInst+ "</TD>";
					
					if (record.dmpContentTypeId == "1001")
					{
						fieldEntry +=  "<TD>Question/Statement</TD>";
					}
					else if (record.dmpContentTypeId == "1002")
					{
						fieldEntry +=  "<TD>Educational</TD>";
					}
					else if (record.dmpContentTypeId == "1003")
					{
						fieldEntry +=  "<TD>Vendor Instruction</TD>";
					}	
					cRows += fieldEntry;
					cRows += "</TR>";
				}
				
				cContents = cContents.replace( "##ROWS##", cRows );
				cContents = cContents.replace( "##TITLE##", dmpName.toUpperCase() + " Export" );
				
				bytes.writeMultiByte( cContents, "utf-8" );
				model.dataByteArray = bytes;
				model.fileDate = formatDateForSaving();
				
			} 
			catch (e:Error) 
			{
				Alert.show("Error producing excel export" );
			}
		}
		
		public function exportToExcelForQIR(dataGrid:Object):void 
		{
			
			var dataProviderCollection:ArrayCollection = dataGrid.dataProvider as ArrayCollection;
			
			
			var rowCount:int                           = dataProviderCollection.length;
			var bytes:ByteArray 					   = new ByteArray();
			var cContents:String 					   = qirXLStemplate;
			var dmpName:String 						   = (dataGrid as DataGrid).name;
			
			var headers:Array = (dataGrid as DataGrid).columns;
			
			try 
			{ 
				
				var cHeaders:String = buildQIRHeader(headers);

				var cRows:String = "";
				cContents = cContents.replace( "##HEADERS##", cHeaders );
				
				var model:SimpleExcelModel = SimpleExcelModel.getInstance();
		
				var fieldEntry:String = "";	
				
				dataProviderCollection = sortDataCollection(dataProviderCollection);
				
				for( var r2:int = 0; r2 < rowCount; r2++ ) 
				{
					var record:QIR = dataProviderCollection.getItemAt(r2) as QIR ;
					
					
					cRows += "<TR STYLE=\"border:Solid 1px Black; text-align:Left\">";
					fieldEntry = "";			
					
					fieldEntry +=  "<TD>" + record.id + "</TD>";							// 1) Tracking Number
					
					var statusType:String = getLabelOrNA(record.qirStatusType);
					fieldEntry +=  "<TD>" +  statusType +  "</TD>"; 	// 2) Status Type
					fieldEntry +=  "<TD>" + record.headline + "</TD>"; 						// 3) Headline
					
					record.complaint = record.complaint.replace("'","\'");
					fieldEntry +=  "<TD>" + record.complaint +  "</TD>";					// 4) Complaint
					
					
					var isDmpIssue:String = null;
					var dmpIssueType:String = null;
					if(record.isDmpIssue == "Y")
					{
						isDmpIssue = "Yes";
						dmpIssueType = record.dmpQirType.label;
					}
					else if (record.isDmpIssue == "N")
					{
						isDmpIssue = "No";
						dmpIssueType = "N/A";
					}
					else
					{
						isDmpIssue = "N/A";
						dmpIssueType = "N/A";						
					}
					
					fieldEntry +=  "<TD>" + isDmpIssue +  "</TD>";					// 5) Is DMP Issue
					fieldEntry +=  "<TD>" + dmpIssueType +  "</TD>";				// 6) DMP Issue Type
					
					fieldEntry +=  "<TD>" + getValueOrNA(record.visn) +  "</TD>"; 			// 7) VISN
					
					
					fieldEntry +=  "<TD>" + record.facilityNumAndName +  "</TD>"; 			// 8) Facility
					fieldEntry +=  "<TD>" + record.submittedByName + "</TD>"; 				// 9) Submitted By
					fieldEntry +=  "<TD>" + formatDate(record.submittedDate) +  "</TD>"; 	// 10) Submitted Date
					
					// Closed Date
					var closedDate:Date = record.closedDate();
					
					if(closedDate != null)
					{
						fieldEntry +=  "<TD>" + formatDate(record.closedDate()) +  "</TD>";
					}
					else
					{
						fieldEntry +=  "<TD>N/A</TD>";
					}
					// End Closed Date
					
					// Number of days open
					
					if(statusType.toLowerCase() != "closed" && statusType.toLowerCase() != "withdrawn")
					{
						fieldEntry +=  "<TD>Active</TD>";
					}
					else if (statusType.toLowerCase() == "withdrawn")
					{
						fieldEntry +=  "<TD>" + statusType + "</TD>";	
					}
					else
					{
						var diff:Number = DateUtils.getElapsedBusinessDays(record.submittedDate, record.statusChangeDate);
						
						fieldEntry +=  "<TD>" + diff +  "</TD>";
					}
					
					// End number of days open
					
					fieldEntry +=  "<TD>" + getLabelOrNA(record.vendor) + "</TD>"; 			// 11) Vendor
					fieldEntry +=  "<TD>" + getLabelOrNA(record.deviceType) +  "</TD>"; 	// 12) Device Model
					
					fieldEntry +=  "<TD>" + getLabelOrNA(record.qirType) +  "</TD>"; 		// 13) QIR Type
					fieldEntry +=  "<TD>" + record.hasAttachment() +  "</TD>";				// 14) Has Attachment
					
					
					var responseDueDate:Date = record.vendorResponseDueDate;
					
					// Get and format replied date
					var repliedDateAsDate:Date = record.lastRepliedDate;
					
					if(repliedDateAsDate != null)
					{
						repliedDateAsDate.hours = 0;
						repliedDateAsDate.minutes = 0;
						repliedDateAsDate.seconds = 0;
						repliedDateAsDate.milliseconds = 0;
					}
					
					fieldEntry +=  "<TD>" + formatDate(responseDueDate) + "</TD>";			// 15) Response Due Date
					
					var repliedDate:String = "N/A";
					if(statusType.toLowerCase() == "replied")
					{
						repliedDate = formatDate(repliedDateAsDate); 	
					}
					
					fieldEntry +=  "<TD>" + repliedDate + "</TD>";			// 16) Replied Date
					
					var metDueDate:String = "N/A";
					var currentDate:Date = new Date();
					if (repliedDate == "N/A" && responseDueDate > currentDate)
					{
						metDueDate = "N/A";
					}
					else if(repliedDate == "N/A" && responseDueDate <= currentDate){
						metDueDate = "No";
					}
					else if(repliedDateAsDate > responseDueDate)
					{
						metDueDate = "No";
					}
					else if(repliedDateAsDate <= responseDueDate)
					{
						metDueDate = "Yes";
					}
					
					
					fieldEntry +=  "<TD>" + metDueDate + "</TD>";						// 17) Met Due Date
					
					
					var remarks:String = record.remarksHistory;
					
					if(remarks != null)
					{
						fieldEntry +=  "<TD>" + remarks + "</TD>";						// 18) Vendor Remarks
					}
					else
					{
						fieldEntry +=  "<TD>"  + "N/A" +  "</TD>";						// 19) Vendor Remarks
					}
					
					fieldEntry +=  "<TD>" + record.vendorActionsHistory + "</TD>"; 			// 20) Vendor Comments
					cRows += fieldEntry;
					
					cRows += "</TR>";
				}
				
				var today:Date = new Date();
				var dateString:String = "Date of Export: " + formatDate(today);
				var titleString:String = "Total count of QIRs contained in this export: " + rowCount;
				cContents = cContents.replace( "##ROWS##", cRows );
				cContents = cContents.replace( "##DATE##", dateString );
				cContents = cContents.replace( "##TITLE##", titleString );
				
				var vendorLogic:String = "<b>* – \'Vendor Met Due Date\' calculation logic:</b>" + 
					"<td><FONT Size=\"-1\">If the Vendor has not yet clicked the Reply button and the Vendor Response Due Date has not yet occurred, \'N/A\' is present in the \'Vendor Met Due Date?\' column.<br>" + 
					"If the Vendor has not yet clicked the Reply button and the Vendor Response Due Date has occurred, \'No\' is present in the \'Vendor Met Due Date?\' column.<br>" +
					"If the Vendor clicks the Reply button prior to or on the same day as the Vendor Response Due Date,  \'Yes\' is present in the \'Vendor Met Due Date?\' column.<br>" +
					"If the Vendor clicks the Reply button after the Vendor Response Due Date, then \'No\' is present In the \'Vendor Met Due Date?\' column.</FONT></td>";
				var qirClosedLogic:String = "<b>** – \'# of Days Open\' calculation logic:</b>" +  
					"<td><FONT Size=\"-1\">If the QIR does not have a status of Withdrawn or Closed,  \'Active\' is present in the \'Status\' column.<br>" + 
					"If the QIR has a status of Withdrawn, \'Withdrawn\' is present in the \'Status\' column. <br>" + 
					"If the QIR is Closed, the Submitted Date was subtracted from the Closed Date and the resulting # of business days the QIR was open is present in the \'# of Days Open\' column.</FONT></td>";
				
				cContents = cContents.replace( "##VENDORLOGIC##", vendorLogic );
				cContents = cContents.replace( "##QIRCLOSEDLOGIC##", qirClosedLogic );
				
				
				
				bytes.writeMultiByte( cContents, "utf-8" );
				model.dataByteArray = bytes;
				model.fileDate = formatDateForSaving();
				
			} 
			catch (e:Error) 
			{
				Alert.show("Error producing excel export" );	
			}
		}
		
		public function exportDmpHTReport(dataGrid:Object) : void 
		{			
			var dataProviderCollection:ArrayCollection = dataGrid.dataProvider as ArrayCollection;
			var rowCount:int                           = dataProviderCollection.length;
			var bytes:ByteArray 					   = new ByteArray();
			var cContents:String 					   = htDMPReportTemplate;
			var dg:DataGrid								= (dataGrid as DataGrid);
			var dmpName:String 						   = dg.name;
			
			var headers:Array = dg.columns;
			
			try
			{				
				var cHeaders:String = buildHeader(headers);
				var cRows:String = "";
				cContents = cContents.replace( "##HEADERS##", cHeaders );
				
				var model:SimpleExcelModel = SimpleExcelModel.getInstance();
				var fromDate:String = formatDate(model.fromDate);
				var toDate:String = formatDate(model.toDate);
				var fieldEntry:String = "";	
				var totalPatients:Number = 0;
				//dataProviderCollection = sortDataCollection(dataProviderCollection);
				
				for( var r2:int = 0; r2 < rowCount; r2++ ) 
				{
					var record:DmpReportEntry = dataProviderCollection.getItemAt(r2) as DmpReportEntry ;
					
					
					cRows += "<TR STYLE=\"border:Solid 1px Black; text-align:Left\">";
					fieldEntry = "";			
					fieldEntry +=  "<TD>" + record.dmp + "</TD>";							// 1) Tracking Number
					
					if(record.facility != null)
					{
						fieldEntry +=  "<TD>&nbsp;" + record.facility + "</TD>";
					}
					
					if(record.visnName != null)
					{
						fieldEntry +=  "<TD>&nbsp;" + record.visnName + "</TD>";
					}
					
					if(record.vendor != null)
					{
						fieldEntry +=  "<TD>&nbsp;" + record.vendor + "</TD>";
					}
					
					
					fieldEntry +=  "<TD>&nbsp;" +  record.numberOfPatients +  "</TD>"; 	// 2) Status Type
					
					cRows += fieldEntry;
					
					cRows += "</TR>";
					totalPatients = totalPatients + record.numberOfPatients;

				}				
				
//				var today:Date = new Date();
				var dateString:String = "From " + fromDate + " to " + toDate;
				var titleString:String = "HT Reports - DMP Response Reports";
				var reportType:String = "Number of Patients " + (dataGrid as DataGrid).name;
				cContents = cContents.replace( "##TOTALPATIENTS##", totalPatients );
				cContents = cContents.replace( "##ROWS##", cRows );				
				cContents = cContents.replace( "##DATE##", dateString );
				cContents = cContents.replace( "##TITLE##", titleString );
				cContents = cContents.replace( "##REPORTTYPE##", reportType );
				
				bytes.writeMultiByte( cContents, "utf-8" );
				model.dataByteArray = bytes;
				model.fileDate = formatDateForSaving();
				
			}
			catch(e:Error)
			{
				Alert.show("Error producing excel export" );
			}			
		}
		
		private function buildHeader(headers:Array) : String
		{
			var cHeaders:String = "";
			var cRows:String = "";
			for each ( var hName2:Object in headers ) 
			{
				var column2:DataGridColumn = (hName2 as DataGridColumn);
				var colName2:String        = column2.headerText ;
				cHeaders += "<TD><span style=\"font-weight: bold;\">" + colName2 + " " + "</span></TD>";	
			}
			cHeaders += "";
			return cHeaders;
		}
		
		private function buildQIRHeader(headers:Array) : String
		{
			var cHeaders:String = "";
			var cRows:String = "";
			for each ( var hName2:Object in headers ) 
			{
				var column2:DataGridColumn = (hName2 as DataGridColumn);
				var colName2:String        = column2.headerText ;
				cHeaders += "<TD x:autofilter='all' style=\"background-color:#A4A4A4;\"><span style=\"font-weight: bold;\">" + colName2 + " " + "</span></TD>";	
			}
			cHeaders += "";
			return cHeaders;
		}
		private function sortDataCollection(dataProviderCollection:ArrayCollection):ArrayCollection
		{
			// Create the properties to sort by
			var dataSortField:SortField = new SortField();
			dataSortField.name = "id";
			dataSortField.numeric = false;
			dataSortField.descending = false;
			
			// Create the sort object to sort with
			var dataSort:Sort = new Sort();
			dataSort.fields = [dataSortField];
			
			// Do the sort
			dataProviderCollection.sort = dataSort;
			dataProviderCollection.refresh();
			
			return dataProviderCollection;
		}
		
		private function getValueOrNA(input:TermType):String {
			return input == null ? "N/A" : input.value;
		}
		
		private function getLabelOrNA(input:TermType):String {
			return input == null ? "N/A" : input.label;
		}
		
		protected function formatDateForSaving():String 
		{
			var df:DateFormatter = new DateFormatter();
			df.formatString = "MMDDYYYY";
			return df.format(new Date()); 
		}
		
		protected function formatDate(date:Date):String 
		{
			var df:DateFormatter = new DateFormatter();
			df.formatString = "MM/DD/YYYY";
			
			if(date != null)
			{
				return df.format(date);
			}
			else
			{
				return "N/A";
			}
		}
	}
}