package gov.va.med.ccht.ui.common.utils
{
	
	import flash.display.DisplayObject;
	import flash.display.DisplayObjectContainer;
	import flash.display.Sprite;
	
	import gov.va.med.ccht.ui.common.command.AppConstants;
	import gov.va.med.ccht.ui.common.view.CchtStage;
	import gov.va.med.fw.controls.DateField;
	
	import mx.controls.Alert;
	import mx.core.Application;
	import mx.core.Container;
	import mx.core.FlexGlobals;
	import mx.managers.ToolTipManager;
	
	public class UIUtils
	{
		public function UIUtils()
		{
		}
		
		public static function findParentByName(o:DisplayObject, name:String):DisplayObjectContainer
		{
			var p:DisplayObjectContainer = o.parent;
			while (p!=null)
			{
				if(p.name == name)
				{
					return p;
				}
				p = p.parent;
			}
			return null;
		}
		
		public static function findCchtStage(o:DisplayObject):CchtStage
		{
			if(FlexGlobals.topLevelApplication !=null)
			{
				if(FlexGlobals.topLevelApplication.hasOwnProperty("cchtStage"))
					return (FlexGlobals.topLevelApplication["cchtStage"] as CchtStage);
			}
			return findParentByName(o, "cchtStage") as CchtStage;
		}
		
		public static function markBoxAsInvalid(container : Container) : void 
		{
           	container.setStyle('borderStyle', 'solid');
           	container.setStyle('borderColor', 'red');
        }
    
        public static function markBoxAsValid(container : Container) : void 
        {
           	container.setStyle('borderStyle', 'none');
           	if (ToolTipManager.currentTarget == container &&
               	ToolTipManager.currentToolTip != null) 
               {
               	ToolTipManager.currentToolTip.visible = false;
           	}
        }
		
		/**
		 * Common Alert display box
		 */
		public static function alert(text:String = "", title:String = "", flags:uint = 0x4, parent:Sprite = null, 
			closeHandler:Function = null, iconClass:Class = null, defaultButtonFlag:uint = 0x4, x:Number = -1, y:Number = -1):void {
			var alert:Alert = Alert.show(text, title, flags, parent, closeHandler, iconClass, defaultButtonFlag);
			x = (x == -1) ? (FlexGlobals.topLevelApplication.width/2) - (alert.width/2) : x;
			y = (y == -1) ? AppConstants.POPUP_WINDOW_POSITION_Y : y;
			alert.validateNow();
			alert.move(x,y);
		}
		
		/**
		 * Reset Date Field Calander control - defaults to current date
		 */
		public static function resetDateField(dateField:DateField, date:Date = null):void {
			if (dateField) {
				dateField.open(); 
				var curDate:Date = date == null ? new Date() : date; 
				dateField.displayedMonth = curDate.getMonth(); 
				dateField.displayedYear = curDate.getFullYear(); 
				dateField.selectedDate = null; 
				dateField.close(); 
			} 
		}
		
		public static function min(value1:int, value2:int):int {
			return value1 > value2 ? value2 : value1;
		}
		public static function max(value1:int, value2:int):int {
			return value1 > value2 ? value1 : value2;
		}
	}
}