package gov.va.med.ccht.ui.common.utils
{
	import flash.accessibility.Accessibility;
	import flash.events.Event;
	import flash.net.FileReference;
	import flash.sampler.getInvocationCount;
	import flash.utils.ByteArray;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	
	import gov.va.med.ccht.ui.common.command.CchtServiceLocator;
	import gov.va.med.ccht.ui.common.model.FormattedDate;
	import gov.va.med.ccht.ui.common.model.QIR;
	import gov.va.med.ccht.ui.common.model.QIRSearchResult;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGenerator;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGeneratorFactory;
	import gov.va.med.ccht.ui.common.utils.excel.SimpleExcelModel;
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.rpc.CustomRemoteObject;
	import gov.va.med.fw.utils.DateUtils;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.FlexGlobals;
	import mx.events.CloseEvent;
	import mx.formatters.DateFormatter;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.RemoteObject;
	import mx.utils.ObjectUtil;
	
	public class QIRExcelExportManager extends ExcelManager
	{
		[Bindable] private var qirName:String = "";
		[Bindable] private var numRecords:int = 0;
		
		private var qirController:CustomRemoteObject = 
			CchtServiceLocator.getInstance().qirController as CustomRemoteObject;
		
		
		public function QIRExcelExport()
		{
			
		}
		
		public function executeExport(listToExport:ArrayCollection ):void 
		{			
			fileName = "IHTA QIRs "; 
			numRecords = listToExport.length;
			//var ids:String = getQIRIds(listToExport);
			qirController.invokeRemoteSimple("getQIRs", [listToExport], exportList, reportFaultHandler);
		}
	
		private function exportList(e:ResultEvent):void
		{
			
			var result:ArrayCollection = e.result as ArrayCollection;
			
			var dg:DataGrid=new DataGrid();
			var columns:Array=[];
			var contentList:ArrayCollection= new ArrayCollection();
					
			var model:SimpleExcelModel = SimpleExcelModel.getInstance();
			var df:DateFormatter = new DateFormatter();
			df.formatString = "MMDDYYYY";
			var fileName:String = "IHTA QIR ";
			var date:String = df.format(new Date());
			
			model.fileName = fileName + date;
			
			// Column 1 - Tracking Number
			var tnGridColumn:DataGridColumn = getGridColumn("TN","Tracking Number");			
			columns.push(tnGridColumn);
			
			//Status
			var statusColumn:DataGridColumn = getGridColumn("Status","Status");			
			columns.push(statusColumn);
			
			//Headline
			var headlineColumn:DataGridColumn = getGridColumn("Headline","Headline");			
			columns.push(headlineColumn);				
			
			//cause of complaint
			var complaintCauseGridColumn:DataGridColumn = getGridColumn("Complaint Cause","Complaint Cause");			
			columns.push(complaintCauseGridColumn);
			
			// DMP Issue
			var dmpIssueGridColumn:DataGridColumn = getGridColumn("DMP Issue","DMP Issue");			
			columns.push(dmpIssueGridColumn);
			
			// Type of DMP Issue
			var dmpIssueTypeGridColumn:DataGridColumn = getGridColumn("Type of DMP","Type of DMP");			
			columns.push(dmpIssueTypeGridColumn);
			
			//VISN
			var visnColumn:DataGridColumn = getGridColumn("VISN","VISN");			
			columns.push(visnColumn);
			
			
			//Facility
			var facilityGridColumn:DataGridColumn = getGridColumn("Facility","Facility");			
			columns.push(facilityGridColumn);
			
			//Submitted by
			var submittedByGridColumn:DataGridColumn = getGridColumn("Submitted By","Submitted By");			
			columns.push(submittedByGridColumn);
			
			//Submitted Date
			var submittedDateGridColumn:DataGridColumn = getGridColumn("Submitted Date","Submitted Date");			
			columns.push(submittedDateGridColumn);
			
			//Closed Date
			var submittedDateGridColumn:DataGridColumn = getGridColumn("Closed Date","Closed Date");			
			columns.push(submittedDateGridColumn);
			
			//# of Days Open
			var submittedDateGridColumn:DataGridColumn = getGridColumn("# of Days Open**","# of Days Open**");			
			columns.push(submittedDateGridColumn);
			
			//Vendor
			var vendorGridColumn:DataGridColumn = getGridColumn("Vendor","Vendor");			
			columns.push(vendorGridColumn);
			
			//Device Model
			var deviceGridColumn:DataGridColumn = getGridColumn("Device Model", "Device Model");			
			columns.push(deviceGridColumn);
			
			//Type
			var typeGridColumn:DataGridColumn = getGridColumn("Type","Type");			
			columns.push(typeGridColumn);
				
			
			//whether or not this has an attachment"
			var hasAttachmentGridColumn:DataGridColumn = getGridColumn("Has Attachment","Has Attachment");			
			columns.push(hasAttachmentGridColumn);			
								
			 
			//Response Due Date 
			var responseDueDateDateGridColumn:DataGridColumn = getGridColumn("Vendor Response Due Date","Vendor Response Due Date");			
			columns.push(responseDueDateDateGridColumn);
			
			//Replied Date (the most recent date the Vendor clicked the REPLY button)
			var repliedDateGridColumn:DataGridColumn = getGridColumn("Date Vendor Replied","Date Vendor Replied");			
			columns.push(repliedDateGridColumn);
			
			//Replied Date (the most recent date the Vendor clicked the REPLY button)
			var repliedDateGridColumn:DataGridColumn = getGridColumn("Vendor Met Due Date?*","Vendor Met Due Date?*");			
			columns.push(repliedDateGridColumn);
			
			//Vendor comments (entire vendor comment history contents).
			var remarksGridColumn:DataGridColumn = getGridColumn("Remarks","Remarks");			
			columns.push(remarksGridColumn);
			
			//Vendor comments (entire vendor comment history contents).
			var vendorCommentsGridColumn:DataGridColumn = getGridColumn("Vendor Comments","Vendor Comments");			
			columns.push(vendorCommentsGridColumn);			
			
			dg.columns=columns;
			dg.dataProvider= result;
			dg.name = "IHTA QIR";
			
			var excelGenerator:ExcelGenerator=ExcelGeneratorFactory.getDefaultGenerator();
			excelGenerator.getExcelSaveAs(dg);
				
			if(!Accessibility.active){
				
			Alert.show("Would you like to export this list?", "File Ready", Alert.YES | Alert.NO, null, exportFile);
			}
			else if(Accessibility.active){
				Alert.show("File Ready. Would you like to export this list?", "File Ready", Alert.YES | Alert.NO, null, exportFile);
			}
									
		}
		
		public function genBinaryFile(selectedQIR:QIRSearchResult):void 
		{
			//dmpController.invokeRemoteSimple("exportQIR", [selectedQIR], mailBinaryHandler, myRO_faultHandler);
		}
		
		
		public function qirFaultHandler(e:FaultEvent):void
		{
			Alert.show(" RESULT ERROR " + e.fault.faultString);
		}
		
	}
}