package gov.va.med.ccht.ui.common.utils
{
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.FileReference;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	
	import gov.va.med.fw.model.TermType;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	


	public class PSSReportUtils
	{
	
		public static var NATIONAL_SURVEY_STATS_RADIO_BUTTON:String = "National Survey Statistics";
		public static var VISN_SURVEY_STATS_RADIO_BUTTON:String = "VISN Survey Statistics";
		public static var FACILITY_SURVEY_STATS_RADIO_BUTTON:String = "Facility Survey Statistics";
		
		public static var NATIONAL_SURVEY_REPORT_TYPE:int = 0;
		public static var VISN_SURVEY_REPORT_TYPE:int = 1;
		public static var FACILITY_SURVEY_REPORT_TYPE:int = 2;

		private static var VR_TWELVE_QUESTION:int = 1;
		private static var VER_ONE_QUESTIONS:int = 2;
		private static var VER_TWO_QUESTIONS:int = 3;
		
		public static var ALL_VENDORS:String = "All Vendors";
		
		public static var styleText:String = 
			'body {margin: 100px; font-family: Arial, Helvetica, sans-serif; font-size: 14pt; text-decoration: none; font-weight: normal; color: black; height: 100%; }' +
			'.centertag {text-align: center;}' +
			'.colorblue {color: #0000ff;}' +
			'.pageheading { color: #000080; text-align: center; font-size: 22pt; font-weight:bold; text-decoration: none;}' + 
			'.basictext {font-size:14;}' +
			'.ombtext {font-size:11; text-align: center;}' +
			'.burdentext {font-size:11;  text-align: center;}' +
			'.paperworkreductiontext {font-size:10;}' +
			'.headertext {font-size:20; font-weight:bold;}' +
			'.vrtwoheadertext {font-size:20; font-weight:bold; text-align:center}' +
			'.questionairretext { color: #0000ff; font-size:18; font-weight:bold;}' + 
			'.vertwofootertext {font-size:11; font-weight: bold; text-align: left;}';
		
		
		
		
		public function PSSReportUtils()
		{
		}
		
		public static function downloadWordDoc(theFile:int):void
		{
			var req:URLRequest = null;
			var file:FileReference = null;
			var saveAsFileName:String = "";
			switch(theFile)
			{
				case VR_TWELVE_QUESTION:
					req = new URLRequest("./docs/VR-12SurveyV1.doc");
					saveAsFileName = "VR-12SurveyV1.doc";
					file = new FileReference();
					break;
				case VER_ONE_QUESTIONS:
					req = new URLRequest("./docs/PatSatSurveyV1.doc");
					saveAsFileName = "PatSatSurveyV1.doc";
					file = new FileReference();
					break;
				case VER_TWO_QUESTIONS:
					req = new URLRequest("./docs/PatSatSurveyV2.doc");
					saveAsFileName = "PatSatSurveyV2.doc";
					file = new FileReference();
				break;
			}
			
			if(file != null)
			{
				file.addEventListener(Event.COMPLETE, completeHandler);
				file.addEventListener(Event.CANCEL, cancelHandler);
				file.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
				file.download(req, saveAsFileName);
			}
				
		}
		
		private static function completeHandler(event:Event):void
		{
			Alert.show("Download Complete");
		}
		
		private static function cancelHandler(event:Event):void
		{
			Alert.show("User canceled the download");
		}
		
		private static function ioErrorHandler(event:Event):void
		{
			Alert.show("Error occured");
		}


		
		public static function getSelectedReportType(selectedReport:String):int
		{
			if(selectedReport == NATIONAL_SURVEY_STATS_RADIO_BUTTON)
			{
				return NATIONAL_SURVEY_REPORT_TYPE;
				//selectedReportTypeHeader = NATIONAL_SURVEY_STATS_RADIO_BUTTON;
			}
			else if(selectedReport == VISN_SURVEY_STATS_RADIO_BUTTON)
			{
				return VISN_SURVEY_REPORT_TYPE;
				//selectedReportTypeHeader = VISN_SURVEY_STATS_RADIO_BUTTON;					
			}
			else if(selectedReport == FACILITY_SURVEY_STATS_RADIO_BUTTON)
			{
				return FACILITY_SURVEY_REPORT_TYPE;	
				//selectedReportTypeHeader = VISN_SURVEY_STATS_RADIO_BUTTON;
			}
			
			return -1;
		}
		
		
		/*
		* Combo Selection Function
		*/
		public static function getSelectedVisn(selectedVisn:String, visnList:ArrayCollection):TermType
		{
			var retVal:TermType = new TermType();
			var tempVisnList:ArrayCollection = new ArrayCollection();
			tempVisnList.addAll(visnList);
			tempVisnList.removeItemAt(0);
			
			for each(var visn:TermType in tempVisnList)
			{					
				if(selectedVisn	== visn.value)
				{							
					return visn;				
				}
			}
			
			return retVal;
		}
		
		
		public static function getSelectedFacility(selectedFacility:String, facilityList:ArrayCollection):TermType
		{
			var retVal:TermType = new TermType();
			var tempFacilityList:ArrayCollection = new ArrayCollection();
			tempFacilityList.addAll(facilityList);
			tempFacilityList.removeItemAt(0);
			
			for each(var facility:TermType in tempFacilityList)
			{					
				if(selectedFacility	== facility.value)
				{							
					return facility;				
				}
			}
			
			return retVal;
		}
		
		
		/*
		* Date Functions
		*/
		public static function getMMYYDateFromDropDownString(selectedDate:String):Date
		{
			var day:int = 1;
			var month:String = selectedDate.slice(0, 2);
			var month_int:int = parseInt(month) - 1;
			var year:String = selectedDate.slice(3, selectedDate.length);
			var year_int:int =  parseInt(year);
			var theDate:Date = new Date();
			theDate.date = day;
			theDate.fullYear = year_int;
			theDate.month = month_int;
			theDate.hours = 0;
			theDate.minutes = 0;
			theDate.seconds = 0;
			
			//Alert.show("from date:"+theDate.toString());
			return theDate;				
		}
		
		/*
		* Find the end date of a given month
		*/
		public static function getMMYYEndDateFromDropDownString(selectedDate:String):Date
		{			
			var month:String = selectedDate.slice(0, 2);
			var month_int:int = parseInt(month) - 1;
			var year:String = selectedDate.slice(3, selectedDate.length);
			var year_int:int =  parseInt(year);
			
			var endDate:Date = new Date(year_int, ++month_int, 0);		
			endDate.hours=23;
			endDate.minutes=59;
			endDate.seconds=59;
			
			//Alert.show("end date:"+endDate.toString());
			
			return endDate;				
		}
		
		
		public static function getMMDDYYYYDateFromDropDownString(selectedDate:String):Date
		{
			var month:String = selectedDate.slice(0, 2);
			var month_int:int = parseInt(month) - 1;			
			var day:String = selectedDate.slice(3, 5);
			var day_int:int = parseInt(day);
			var year:String = selectedDate.slice(6, selectedDate.length);
			var year_int:int =  parseInt(year);
			
			var theDate:Date = new Date();
			
			theDate.fullYear = year_int;
			theDate.month = month_int;
			theDate.date = day_int;
			
			return theDate;				
		}
		
		
		public static function compareDates(fromDate:Date, toDate:Date):Boolean
		{
			var tempFromDate:Date = fromDate;
			var tempToDate:Date = toDate;
			
			/*
			tempFromDate.hours = 0;
			tempFromDate.minutes = 0;
			tempFromDate.seconds = 0;
			tempFromDate.milliseconds = 0;
			
			
			tempToDate.hours = 0;
			tempToDate.minutes = 0;
			tempToDate.seconds = 0;
			tempToDate.milliseconds = 0;
			*/
			var fromDateTimeStamp:Number = tempFromDate.getTime();
			var toDateTimeStamp:Number = tempToDate.getTime();
			
			return fromDateTimeStamp <= toDateTimeStamp;
		}

		
		public static function getMMDDYYYYTimeFromDateAsString(theDate:Date):String
		{
			var retDate:String = "";
			
			if(theDate != null)
			{
				var month:int = theDate.month + 1;
				var date:int = theDate.date;
				var year:int = theDate.fullYear;
				
				var hours:int = theDate.hours;
				var minutes:int = theDate.minutes;
				var seconds:int = theDate.seconds;
				
				var ampm:String = "AM";
				var hoursAsString = "";
				if(hours > 12)
				{
					hours = hours - 12;
					hoursAsString = "0" + hours;
					ampm = "PM";
				}
				else
				{
					hoursAsString = "0" + hours;
				}
				
				var monthAsString:String = "";
				if(month < 10)
				{
					monthAsString = "0" + month;
				}
				else
				{
					monthAsString += month;
				}
				
				retDate = monthAsString +"/" + date + "/" + year + " " + hoursAsString + ":" + minutes + ":" + seconds + " " + ampm;
				
			}
			
			return retDate;
		}
		
		
		public static function getMMDDYYYYFromDateAsString(theDate:Date):String
		{
			var retDate:String = "";
			
			if(theDate != null)
			{
				var month:int = theDate.month + 1;
				var date:int = theDate.date;
				var year:int = theDate.fullYear;
				
				
				var monthAsString:String = "";
				var dateAsString:String = "";
				if(month < 10)
				{
					monthAsString = "0" + month;
				}
				else
				{
					monthAsString += month;
				}
				
				if(date < 10)
				{
					dateAsString = "0" + date;
				}
				else
				{
					dateAsString += date;
				}
				
				
				retDate = monthAsString +"/" + dateAsString + "/" + year;
				
			}
			
			return retDate;
		}
		
		/*
		 * Link functions
		*/
		public static function vrTwelveClickHandler():void
		{
			
			var urlReq:URLRequest = new URLRequest("/VR-12SurveyV1.doc");
			navigateToURL(urlReq, "_blank");
		}
		
		public static function versionOneClickHandler():void
		{
			var urlReq:URLRequest = new URLRequest("/PatSatSurveyV1.doc");
			navigateToURL(urlReq, "_blank");
		}
		
		public static function versionTwoClickHandler():void
		{
			var urlReq:URLRequest = new URLRequest("/PatSatSurveyV2.doc");
			navigateToURL(urlReq, "_blank");
		}
	
	
		/*
		*
		*/
		public static function getCensusActivityModalities():ArrayCollection
		{
			var retVal:ArrayCollection = new ArrayCollection();			

			var termType:TermType = TermType.create("All Modalities", "All Modalities"); 
			retVal.addItem(termType);
			
			termType = TermType.create("Messaging Total", "Messaging Total");
			retVal.addItem(termType);
			
			termType = TermType.create("Messaging by Device", "Messaging by Device");
			retVal.addItem(termType);
			
			termType = TermType.create("Messaging by IVR", "Messaging by IVR");
			retVal.addItem(termType);
			
			termType = TermType.create("Messaging by Browser", "Messaging by Browser");
			retVal.addItem(termType);
			
			termType = TermType.create("*Messaging (IVR, device or browser not yet assigned)", "*Messaging (IVR, device or browser not yet assigned)");
			retVal.addItem(termType);
			
			termType = TermType.create("Peripheral Measurements", "Peripheral Measurements");
			retVal.addItem(termType);
			
			termType = TermType.create("Video", "Video");
			retVal.addItem(termType);
			
			termType = TermType.create("Cellular Modem Transmission", "Cellular Modem Transmission");
			retVal.addItem(termType);
			
			termType = TermType.create("Satellite Transmission", "Satellite Transmission");
			retVal.addItem(termType);
			
			termType = TermType.create("Digital Image Capture", "Digital Image Capture");
			retVal.addItem(termType);
			
			termType = TermType.create("Category of Care Report", "Category of Care Report");
			retVal.addItem(termType);
			
			termType = TermType.create("Response Rate Report", "Response Rate Report");
			retVal.addItem(termType);
			
			
			return retVal;
			
			
		}
	}
}