package gov.va.med.ccht.ui.common.utils {
	
	import gov.va.med.ccht.ui.common.command.AppConstants;
	import gov.va.med.ccht.ui.common.command.CCHTPermissions;
	import gov.va.med.ccht.ui.common.command.ClientSession;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;

	public class MenuBuilder {

		
		private static var myProfileMenuXml:XML = null;
		private static var adminMenuXml:XML = null;
		private static var inventoryMenuXml:XML = null;
		private static var vendorComplianceSubMenu:String = null;
		private static var searchDeviceInventorySubMenu:String = null;
		private static var inventoryReportsSubMenu:String = null;
		private static var manageDevicesSubMenu:String = null;
		private static var manageQIRSubMenu:String = null;
		private static var dmpMenuXml:XML = null;
		private static var htReportMenuXml:XML = null;
		private static var manageDMPSubMenu:String = null;
		private static var manageHtReportSubMenu:String = null;
		
		public static function buildDMPMenu():XML {
			if(dmpMenuXml == null) {
				var menuData:String = new String();
				buildDMPSubMenu();
				if( manageDMPSubMenu != null && manageDMPSubMenu.length > 0) {
					menuData = menuData.concat(manageDMPSubMenu);
				}
				menuData =  '<root>' + menuData + '</root>';				
				dmpMenuXml = new XML(menuData);
			}
			return dmpMenuXml;
		}
		
		public static function buildHTReportMenu():XML {
			if(htReportMenuXml == null) {
				var menuData:String = new String();
				
				if(!ClientSession.isAuthorized(CCHTPermissions.VENDOR))
				{					
					buildHtReportSubMenu();
					
					menuData = manageHtReportSubMenu;					
				}				
				menuData =  '<root>' + menuData + '</root>';				
				htReportMenuXml = new XML(menuData);
			}
			return htReportMenuXml;
		}

		
		private static function buildHtReportSubMenu():void
		{
			if(manageHtReportSubMenu == null)
			{
				var menuItem:String = new String();
				var menuItems:String = new String();
				menuItems = menuItems.concat('<menuitem label="DMP Response Reports" hotKey="" data="'	+ AppConstants.DMP_REPORTS + '"/>');
				
				menuItems = menuItems.concat('<menuitem label="Patient Survey Reports" hotKey="" icon="rightArraw">');				
					menuItems = menuItems.concat('<menuitem label="Vendor Submission Report" hotKey="" data="'	+ AppConstants.VENDOR_SUBMISSION_REPORT + '"/>');
					menuItems = menuItems.concat('<menuitem label="VR-12 Surveys" hotKey="" data="'	+ AppConstants.VR_TWELVE_SURVEY + '"/>');
					menuItems = menuItems.concat('<menuitem label="Satisfaction Survey Results" hotKey="" data="'	+ AppConstants.SATISFACTION_SURVEY_RESULT + '"/>');
					menuItems = menuItems.concat('<menuitem label="Distribution of Surveys" hotKey="" data="'	+ AppConstants.SURVEY_DISTRIBUTION + '"/>');
					menuItems = menuItems.concat('<menuitem label="Satisfaction Survey Trend Charts" hotKey="" data="'	+ AppConstants.SATISFACTION_SURVEY_RESULT_CHART + '"/>');				
				menuItems = menuItems.concat('</menuitem>');
				
				menuItems = menuItems.concat('<menuitem label="Census Reports" hotKey="" icon="rightArraw">');
					menuItems = menuItems.concat('<menuitem label="Census Activity Reports" hotKey="" data="'	+ AppConstants.CENSUS_ACTIVITY_REPORT + '"/>');
				menuItems = menuItems.concat('</menuitem>');
				
				manageHtReportSubMenu = menuItems;
			}
			
		}

		
				
		public static function buildMyProfileMenu():XML {
			if (myProfileMenuXml == null) {
				var menuData:String = new String();
				// No permission check and all users can update their preferences			
				menuData = menuData.concat('<menuitem label="My Preferences" hotKey="" data="' 
					+ AppConstants.USER_PROFILE + '"/>');
				
				menuData =  '<root>' + menuData + '</root>';				
				myProfileMenuXml = new XML(menuData);
			}
			
			return myProfileMenuXml;
		}
		public static function buildAdminMenu():XML { 
			if(adminMenuXml == null) {
				var menuData:String = new String();
				if (ClientSession.isAuthorized(CCHTPermissions.MANAGE_REGISTRATIONS)) {
					menuData = menuData.concat('<menuitem label="Manage Registrations" hotKey="" data="' 
						+ AppConstants.MANAGE_REGISTRATIONS + '"/>');
				}
				if (ClientSession.isAuthorized(CCHTPermissions.MANAGE_USERS) || ClientSession.isAuthorized(CCHTPermissions.APPLICATION_ADMIN)) {
					menuData = menuData.concat('<menuitem label="Manage Users" hotKey="" data="' 
						+ AppConstants.MANAGE_USERS + '"/>');
				}
				if (ClientSession.isAuthorized(CCHTPermissions.MANAGE_ROLES)) {
					menuData = menuData.concat('<menuitem label="Manage Roles" hotKey="" data="' 
						+ AppConstants.MANAGE_ROLES + '"/>');
				}								
				if (ClientSession.isAuthorized(CCHTPermissions.MANAGE_BATCH_JOBS)) {				
					menuData = menuData.concat('<menuitem label="Manage Scheduled Jobs" hotKey="" data="' 
						+ AppConstants.MANAGE_BATCH_JOBS + '"/>');
				}
			menuData =  '<root>' + menuData + '</root>';				
				adminMenuXml = new XML(menuData);
			}
			return adminMenuXml;
		}
		
		public static function buildInventoryMenu():XML { 
			if(inventoryMenuXml == null) {
				var menuData:String = new String();
				buildInventoryReportsSubMenu();
				if (inventoryReportsSubMenu != null && inventoryReportsSubMenu.length > 0) {
					menuData = menuData.concat(inventoryReportsSubMenu);
				}
				//build search device sub menu	
				buildSearchDeviceInventorySubMenu();
				if (searchDeviceInventorySubMenu != null && searchDeviceInventorySubMenu.length > 0) {
					menuData = menuData.concat(searchDeviceInventorySubMenu);
				}				
				//build vc sub menu
				buildVendorComplianceSubMenu();					
				if (vendorComplianceSubMenu != null && vendorComplianceSubMenu.length > 0) {
					menuData = menuData.concat(vendorComplianceSubMenu);
				}
				buildManageQIRSubMenu();
				if (manageQIRSubMenu != null && manageQIRSubMenu.length > 0) {
					menuData = menuData.concat(manageQIRSubMenu);
				}
				menuData =  '<root>' + menuData + '</root>'; 
				inventoryMenuXml = new XML(menuData);
			}
			return inventoryMenuXml;
		}
		private static function buildInventoryReportsSubMenu():void {
			if (inventoryReportsSubMenu == null) {
				var menuItem:String = new String();
				var menuItems:String = new String();				
				if (ClientSession.isAuthorizedAny((new ArrayCollection(CCHTPermissions.INVENTORY_REPORT_PERMISSIONS)))) {
					menuItems = menuItems.concat('<menuitem label="List" hotKey="" data="' + 
						AppConstants.INVENTORY_REPORTS + '"/>');
					menuItems = menuItems.concat('<menuitem label="Completed" hotKey="" data="' + 
						AppConstants.COMPLETED_INVENTORY_REPORTS + '"/>');
					menuItems = menuItems.concat('<menuitem label="Scheduled" hotKey="" data="' + 
						AppConstants.SCHEDULED_INVENTORY_REPORTS + '"/>');
				}
				if (menuItems.length > 0) {
					menuItem = menuItem.concat('<menuitem label="Reports" icon="rightArraw">'
						+ menuItems + '</menuitem>');
				}
				inventoryReportsSubMenu = menuItem;
			}
		}
						
		private static function buildSearchDeviceInventorySubMenu():void {
			if (searchDeviceInventorySubMenu == null) {
				var menuItem:String = new String();				
				var menuItems:String = new String();
				if (ClientSession.isAuthorized(CCHTPermissions.SEARCH_DEVICE_BY_SERIAL_NUMBER)) {
					menuItems = menuItems.concat('<menuitem label="Serial Number" hotKey="" data="' + 
						AppConstants.SEARCH_DEVICE_BY_NAME_SN + '"/>');
				}
				if (ClientSession.isAuthorized(CCHTPermissions.SEARCH_DEVICE_BY_ACTIVATION_DATE)) {
					menuItems = menuItems.concat('<menuitem label="Activation Date" hotKey="" data="' + 
						AppConstants.SEARCH_DEVICE_BY_ACTIVATION_DATE + '"/>');
				}
				if (menuItems.length > 0) {
					menuItem =  menuItem.concat('<menuitem label="Search Device Inventory" icon="rightArraw">' 
						+ menuItems + '</menuitem>');
				}				
				searchDeviceInventorySubMenu = menuItem;
			}
		}
		
		private static function buildManageDevicesSubMenu():void {
			if (manageDevicesSubMenu == null) {
				var menuItem:String = new String();				
				var menuItems:String = new String();
				if (ClientSession.isAuthorized(CCHTPermissions.MANGE_DEVICE_STATUS)) {
					menuItems = menuItems.concat('<menuitem label="New" hotKey="" data="' + 
						AppConstants.MANAGE_DEVICE_NEW + '"/>');
					menuItems = menuItems.concat('<menuitem label="Status" hotKey="" data="' + 
						AppConstants.MANAGE_DEVICE_STATUS + '"/>');
				}				
				if (ClientSession.isAuthorized(CCHTPermissions.MANGE_DEVICE_SHORTAGE)) {
					menuItems = menuItems.concat('<menuitem label="Shortage" hotKey="" data="' + 
						AppConstants.MANAGE_DEVICE_SHORTAGE + '"/>');
				}
				if (menuItems.length > 0) {
					menuItem =  menuItem.concat('<menuitem label="Manage Devices" icon="rightArraw">' 
						+ menuItems + '</menuitem>');
				}				
				manageDevicesSubMenu = menuItem;
			}
		}		
		
		private static function buildManageQIRSubMenu():void {
			if (manageQIRSubMenu == null) {
				var menuItem:String = new String();				
				var menuItems:String = new String();
				
				if (ClientSession.isAuthorized(CCHTPermissions.CREATE_QIR)) {
					menuItems = menuItems.concat('<menuitem label="New" hotKey="" data="' + 
						AppConstants.MANAGE_QIR_NEW + '"/>');
				}
				if (ClientSession.isAuthorizedAny((new ArrayCollection(CCHTPermissions.QIR_UPDATE_PERMISSIONS)))) {
					menuItems = menuItems.concat('<menuitem label="View My" hotKey="" data="' + 
						AppConstants.MANAGE_QIR_OPEN + '"/>');	
					menuItems = menuItems.concat('<menuitem label="Search All" hotKey="" data="' + 
						AppConstants.MANAGE_QIR_SEARCH + '"/>');
				}else if (ClientSession.isAuthorized(CCHTPermissions.READ_QIR)) {
					menuItems = menuItems.concat('<menuitem label="Search All" hotKey="" data="' + 
						AppConstants.MANAGE_QIR_SEARCH + '"/>');
				}
				if (menuItems.length > 0) {
					menuItem =  menuItem.concat('<menuitem label="Manage QIRs" icon="rightArraw">' 
						+ menuItems + '</menuitem>');
				}				
				manageQIRSubMenu = menuItem;
			}
		}
		
		private static function buildVendorComplianceSubMenu():void {
			if (vendorComplianceSubMenu == null) {
				var menuItem:String = new String();
				if (ClientSession.isAuthorized(CCHTPermissions.VENDOR_COMPLIANCE_REPORTS)) {
					menuItem = menuItem.concat('<menuitem label="Vendor Compliance" icon="rightArraw">');
					menuItem = menuItem.concat('<menuitem label="Current" hotKey="" data="' 
						+ AppConstants.VENDOR_COMPLIANCE_CURRENT + '"/>');
					menuItem = menuItem.concat('<menuitem label="Charts" hotKey="" data="' 
						+ AppConstants.VENDOR_COMPLIANCE_CHARTS + '"/>');
					menuItem = menuItem.concat('<menuitem label="History" hotKey="" data="' 
						+ AppConstants.VENDOR_COMPLIANCE_HISTORY + '"/>');
					menuItem =  menuItem.concat('</menuitem>');
				}
				vendorComplianceSubMenu = menuItem;
			}
		}		
		
	/*	
		private static function buildHtReportSubMenu():void
		{
			if(manageHtReportSubMenu == null)
			{
				var menuItem:String = new String();
				var menuItems:String = new String();
				menuItems = menuItems.concat('<menuitem label="DMP Response Reports" hotKey="" data="'	+ AppConstants.NEW_DMP + '"/>');				
				manageHtReportSubMenu = menuItems;
			}
			
		}
		*/
		private static function buildDMPSubMenu():void {
			if (manageDMPSubMenu == null) {
				if (ClientSession.isAuthorized(CCHTPermissions.DMP)||ClientSession.isAuthorized(CCHTPermissions.DMP_ADMIN)){
				var menuItem:String = new String();
				var menuItems:String = new String();
				if (ClientSession.isAuthorized(CCHTPermissions.DMP_ADMIN)){				
					menuItems = menuItems.concat('<menuitem label="New" hotKey="" data="'	+ AppConstants.NEW_DMP + '"/>');
					menuItems = menuItems.concat('<menuitem label="Find/Replace" hotKey="" data="'	+ AppConstants.FIND_REPLACE_DMP + '"/>');
				}
				menuItems = menuItems.concat('<menuitem label="View My" hotKey="" data="'	+ AppConstants.MY_DMP + '"/>');
				menuItems = menuItems.concat('<menuitem label="Search All" hotKey="" data="' + AppConstants.ALL_DMP + '"/>');
				menuItems = menuItems.concat('<menuitem label="Standardized Library" hotKey="" data="' + AppConstants.DMP_SL + '"/>');
				if(!ClientSession.isAuthorized(CCHTPermissions.DMP_ADMIN)){
					menuItems = menuItems.concat('<menuitem label="Find" hotKey="" data="'	+ AppConstants.FIND_REPLACE_DMP + '"/>');				
				}
				
				if (menuItems.length > 0) {
					menuItem = menuItem.concat('<menuitem label="Manage" icon="rightArraw">'
						+ menuItems + '</menuitem>');
				}
				}
				manageDMPSubMenu = menuItem;
			}			
		}
	}
}