package gov.va.med.ccht.ui.common.utils
{
	import flash.accessibility.Accessibility;
	import flash.events.Event;
	import flash.net.FileReference;
	import flash.sampler.getInvocationCount;
	import flash.utils.ByteArray;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	
	import gov.va.med.ccht.ui.common.command.CchtServiceLocator;
	import gov.va.med.ccht.ui.common.model.DMPReportSearchResult;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGenerator;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGeneratorFactory;
	import gov.va.med.ccht.ui.common.utils.excel.SimpleExcelModel;
	import gov.va.med.ccht.ui.htreport.model.DMPReportParameters;
	import gov.va.med.ccht.ui.htreport.model.DmpReportEntry;
	import gov.va.med.ccht.ui.htreport.view.DMPReport;
	import gov.va.med.fw.model.TermType;
	import gov.va.med.fw.rpc.CustomRemoteObject;
	import gov.va.med.fw.utils.DateUtils;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.FlexGlobals;
	import mx.events.CloseEvent;
	import mx.formatters.DateFormatter;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.RemoteObject;
	import mx.utils.ObjectUtil;
	
	public class HTDmpExcelExportManager extends ExcelManager
	{
		[Bindable] private var reportTypeName:String = "";
		[Bindable] private var fileNameType:String = "";
		[Bindable] private var numPatients:int = 0;
		[Bindable] private var searchBy:Number = 0;
		[Bindable] private var fromDate:Date = null;
		[Bindable] private var toDate:Date = null;
		
		private var htReportController:CustomRemoteObject = 
			CchtServiceLocator.getInstance().htReportController as CustomRemoteObject;
		
		
		public function HTDmpExcelExportManager()
		{
			
		}
		
		
		public function executeExport(listToExport:ArrayCollection ):void 
		{				
			this.fileNameType = "DMP Reports - "; 
			
			var dmpReportParam:DMPReportParameters = listToExport.getItemAt(0) as DMPReportParameters;
			numPatients = dmpReportParam.maxRecords;
			fromDate = dmpReportParam.submittedFromDate;
			toDate = dmpReportParam.submittedToDate;
			searchBy = dmpReportParam.searchBy;
			setReportTypeName();
			htReportController.invokeRemoteSimple("findDmpReports", [dmpReportParam], exportList, reportFaultHandler);
		}
		
		private function exportList(e:ResultEvent):void
		{	
			if (e == null || e.result == null) return;
			var result:DMPReportSearchResult = e.result as DMPReportSearchResult;
			var results:ArrayCollection = result.dmpReportEntryList;
			if (results == null) return;
			var dg:DataGrid=new DataGrid();
			var columns:Array=[];
			var contentList:ArrayCollection= new ArrayCollection();
			
			var model:SimpleExcelModel = SimpleExcelModel.getInstance();			
			model.fileName = "DMP Reports - Patient " + this.fileNameType;
			model.fromDate = fromDate;
			model.toDate = toDate;
			
				
			// Column 1 - DMP Name
			var dmpNameGridColumn:DataGridColumn = getGridColumn("DMP Name","dmp");			
			columns.push(dmpNameGridColumn);
			
			// Determine what columns show at run time:
			switch(searchBy)
			{
				case DMPReport.SEARCH_BY_DMP:
					
					break;
				case DMPReport.SEARCH_BY_DMP_FACILITY:
					
					var facilityGridColumn:DataGridColumn = getGridColumn("Facility","facility");			
					columns.push(facilityGridColumn);
					
					var visnGridColumn:DataGridColumn = getGridColumn("VISN","visnName");			
					columns.push(visnGridColumn);
					
					break;
				case DMPReport.SEARCH_BY_DMP_VENDOR:
					
					var vendorGridColumn:DataGridColumn = getGridColumn("Vendor","vendor");			
					columns.push(vendorGridColumn);
					break;
				case DMPReport.SEARCH_BY_DMP_VISN:
					
					var dmpGridColumn:DataGridColumn = getGridColumn("VISN","visnName");			
					columns.push(dmpGridColumn);
					break;
				
				case DMPReport.SEARCH_BY_DMP_VISN_VENDOR:
					var dmpGridColumn:DataGridColumn = getGridColumn("VISN","visnName");			
					columns.push(dmpGridColumn);
					var vendorGridColumn:DataGridColumn = getGridColumn("Vendor","vendor");			
					columns.push(vendorGridColumn);
					
					break;
				case DMPReport.SEARCH_BY_DMP_FACILITY_VENDOR:
					var facilityGridColumn:DataGridColumn = getGridColumn("Facility","facility");			
					columns.push(facilityGridColumn);
					var dmpGridColumn:DataGridColumn = getGridColumn("VISN","visnName");			
					columns.push(dmpGridColumn);
					var vendorGridColumn:DataGridColumn = getGridColumn("Vendor","vendor");			
					columns.push(vendorGridColumn);
					
					break;
			}
			
			// Number of Patients Responded
			var numPatientsResponded:DataGridColumn = getGridColumn("# of Patients Responded","numberOfPatients");			
			columns.push(numPatientsResponded);
			
			dg.columns=columns;
			dg.dataProvider= results;
			dg.name = reportTypeName;
			
			var excelGenerator:ExcelGenerator=ExcelGeneratorFactory.getDefaultGenerator();
			excelGenerator.getExcelSaveAs(dg);
			
			if(!Accessibility.active)
			{				
				Alert.show("Would you like to export this list?", "File Ready", Alert.YES | Alert.NO, null, exportFile);
			}
			else if(Accessibility.active)
			{
				Alert.show("File Ready. Would you like to export this list?", "File Ready", Alert.YES | Alert.NO, null, exportFile);
			}
		}
	
		private function setReportTypeName():void
		{
			switch(searchBy)
			{
				case DMPReport.SEARCH_BY_DMP:
					this.fileNameType = "By DMP";
					reportTypeName = "by DMP";
					break;
				case DMPReport.SEARCH_BY_DMP_FACILITY:
					this.fileNameType = "By DMP-Faci";
					reportTypeName = "by DMP and Facility";
					break;
				case DMPReport.SEARCH_BY_DMP_VENDOR:
					this.fileNameType = "By DMP-Ven";
					reportTypeName = "by DMP and Vendor";
					break;
				case DMPReport.SEARCH_BY_DMP_VISN:
					this.fileNameType = "By DMP-VISN";
					reportTypeName = "by DMP and VISN";
					break;
				case DMPReport.SEARCH_BY_DMP_VISN_VENDOR:
					this.fileNameType = "By DMP-VISN-Ven";
					reportTypeName = "by DMP, VISN, and Vendor";
					break;
				case DMPReport.SEARCH_BY_DMP_FACILITY_VENDOR:
					this.fileNameType = "By DMP-Faci-Ven";
					reportTypeName = "by DMP, Facility, and Vendor";
					break;		
			}
		}
	}
}