package gov.va.med.ccht.ui.common.utils {

	import flash.accessibility.Accessibility;
	import flash.events.Event;
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	
	import gov.va.med.ccht.ui.common.command.CchtServiceLocator;
	import gov.va.med.ccht.ui.common.model.DMP;
	import gov.va.med.ccht.ui.common.model.DMPContents;
	import gov.va.med.ccht.ui.common.model.DMPExport;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGenerator;
	import gov.va.med.ccht.ui.common.utils.excel.ExcelGeneratorFactory;
	import gov.va.med.ccht.ui.common.utils.excel.SimpleExcelModel;
	import gov.va.med.fw.rpc.CustomRemoteObject;
	
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	import mx.controls.DataGrid;
	import mx.controls.dataGridClasses.DataGridColumn;
	import mx.core.FlexGlobals;
	import mx.events.CloseEvent;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.RemoteObject;
	import mx.utils.ObjectUtil;

	public class ExcelManager {

		[Bindable] public var parentByteArray:ByteArray=new ByteArray();
		[Bindable] private var _dmpName:String="";

		protected var fileName:String = "";
		public var parentDateForSave:String="";

		protected function myRO_faultHandler(e:FaultEvent):void {
			Alert.show(" RESULT ERROR " + e.fault.faultString);
		}
		
		//protected var myRO:RemoteObject;
		protected var myRO:CustomRemoteObject = 
			CchtServiceLocator.getInstance().dmpController as CustomRemoteObject;
		private var dmpController:CustomRemoteObject = 
			CchtServiceLocator.getInstance().dmpController as CustomRemoteObject;
		
		public function ExcelManager() {
		}
		
		
		public function execute(selectedDMP:DMP ):void {
			_dmpName=selectedDMP.name;
			dmpController.invokeRemoteSimple("exportDmp",[selectedDMP],myRO_resultHandler,myRO_faultHandler);
		}
		private var selectedVendor:String;
		private var deployedDMP:DMP;
		public function generateBinaryFile(selectedDMP:DMP, vendor:String ):void {
			selectedVendor=vendor;
			deployedDMP=selectedDMP;
			_dmpName=selectedDMP.name;
			dmpController.invokeRemoteSimple("exportDmp",[selectedDMP],mailBinaryHandler,myRO_faultHandler);
		}
		protected function myRO_resultHandler(e:ResultEvent):void {
			var dmpExport:DMPExport=e.result as DMPExport;

			var qStatementId:String=dmpExport.qStatementId;
			var qStatement:String=dmpExport.qStatement;
			var response:String=dmpExport.response;
			var alertStatus:String=dmpExport.alertStatus;
			var freqQuestions:String=dmpExport.freqQuestions;
			var fbackEducation:String=dmpExport.fbackEducation;
			var lblGoto:String=dmpExport.lblGoto;
			var vendorInstr:String=dmpExport.vendorInstr;

			var dmpId:String=dmpExport.dmpId;
			var dmpName:String=dmpExport.dmpName;
			var dmpDesc:String=dmpExport.dmpDesc;
			var dmpObj:String=dmpExport.dmpObj;
			var dmpTag:String=dmpExport.dmpTag;
			var dmpContentId:String=dmpExport.dmpContentId;
			var dmpContentTypeId:String=dmpExport.dmpContentTypeId;

			var contentList:ArrayCollection=dmpExport.dmpComponentList;

			var dg:DataGrid=new DataGrid();
			var columns:Array=[];

			// Column 1 - QS Order
			var dgc:DataGridColumn=new DataGridColumn();
			dgc.headerText=qStatementId;
			try {
				dgc.dataField=getValueOrNA((contentList.getItemAt(0) as DMPContents).qStmtId);
			} catch (e:Error) {
				dgc.dataField="ERROR";
			}

			columns.push(dgc);

			// Column 2  QS Content
			var dgc1:DataGridColumn=new DataGridColumn();
			dgc1.headerText=qStatement;
			try {
				dgc1.dataField=getValueOrNA((contentList.getItemAt(1) as DMPContents).qStmtIdDesc);
			} catch (e:Error) {
				dgc1.dataField="ERROR";
			}
			columns.push(dgc1);

			// Column 3 Frequency
			var dgc2:DataGridColumn=new DataGridColumn();
			dgc2.headerText=freqQuestions;
			try {
				dgc2.dataField=getValueOrNA((contentList.getItemAt(2) as DMPContents).freqQuestion);
			} catch (e:Error) {
				dgc2.dataField="ERROR";
			}
			columns.push(dgc2);

			// Column 4  RESPONSE CONTENT
			var dgc3:DataGridColumn=new DataGridColumn();
			dgc3.headerText=response;
			try {
				dgc3.dataField=getValueOrNA((contentList.getItemAt(3) as DMPContents).response);
			} catch (e:Error) {
				dgc3.dataField="ERROR";
			}

			columns.push(dgc3);

			// Column 5 Alert Tyep Label
			var dgc4:DataGridColumn=new DataGridColumn();
			dgc4.headerText=alertStatus;
			try {
				dgc4.dataField=getValueOrNA((contentList.getItemAt(4) as DMPContents).alertStatus);
			} catch (e:Error) {
				dgc4.dataField="ERROR";
			}
			columns.push(dgc4);



			// Column 6 Response EC
			var dgc5:DataGridColumn=new DataGridColumn();
			dgc5.headerText=fbackEducation;
			try {
				dgc5.dataField=getValueOrNA((contentList.getItemAt(5) as DMPContents).feedbackEdu);
			} catch (e:Error) {
				dgc5.dataField="ERROR";
			}
			columns.push(dgc5);

			// Column 7 Response Next Question
			var dgc6:DataGridColumn=new DataGridColumn();
			dgc6.headerText=lblGoto;
			try {
				dgc6.dataField=getValueOrNA((contentList.getItemAt(6) as DMPContents).gotoValue);
			} catch (e:Error) {
				dgc6.dataField="ERROR";
			}
			columns.push(dgc6);

			// Column 8 Response Vendor Instr
			var dgc7:DataGridColumn=new DataGridColumn();
			dgc7.headerText=vendorInstr;
			try {
				dgc7.dataField=getValueOrNA((contentList.getItemAt(7) as DMPContents).vendorInst);
			} catch (e:Error) {
				dgc7.dataField="ERROR";
			}
			columns.push(dgc7);
			
			// Column 5 Frequency
			var dgc8:DataGridColumn=new DataGridColumn();
			dgc8.headerText=dmpContentTypeId;
			try {
				dgc8.dataField=getValueOrNA((contentList.getItemAt(14) as DMPContents).dmpContentTypeId);
			} catch (e:Error) {
				dgc4.dataField="ERROR";
			}
			columns.push(dgc8);


			dg.columns=columns;
			dg.dataProvider=contentList;
			dg.name = _dmpName;
			
			Alert.show("Would you like to export this DMP?", "File Ready", Alert.YES | Alert.NO, FlexGlobals.topLevelApplication.parentDocument, saveSelectedFile);

			var excelGenerator:ExcelGenerator=ExcelGeneratorFactory.getDefaultGenerator();
			excelGenerator.getExcelSaveAs(dg);
		}

		public function exportFile(e:CloseEvent):void 
		{			
			if (e.detail == Alert.YES) 
			{				
				var model:SimpleExcelModel=SimpleExcelModel.getInstance();
				var date:String = model.fileDate;
				
				var fr:FileReference=new FileReference();	
				
				fr.save(model.dataByteArray, model.fileName + ".xls");
				
				fr.addEventListener(Event.COMPLETE, saveComplete);
			}
			else
			{
				if(!Accessibility.active){Alert.show("Export process terminated");}
			}
			
		}
		
		protected function saveSelectedFile(e:CloseEvent):void {
			if (e.detail == Alert.YES) {
				try {
					var model:SimpleExcelModel=SimpleExcelModel.getInstance();
					var fr:FileReference=new FileReference();

					fr.save(model.dataByteArray, _dmpName + "_DMP" + model.fileDate + ".xls");
					fr.addEventListener(Event.COMPLETE, saveComplete);

				} catch (error:Error) {
					Alert.show(" [ ExcelManager : saveSelectedFile ] Error found : " + error);
				}

			} else {
				if(!Accessibility.active){Alert.show("Export Process terminated");}
				else if(Accessibility.active){Alert.show("Export Process terminated");}
			}
		}

		public function getValueOrNA(input:String):String {
			return input == null ? "N/A" : input;
		}

		public function saveComplete(e:Event):void 
		{
			if(!Accessibility.active){Alert.show("Export Complete.");}
		}


		
		public function reportFaultHandler(e:FaultEvent):void
		{
			Alert.show(" RESULT ERROR " + e.fault.faultString);
		}
		
		protected function mailBinaryHandler(e:ResultEvent):void 
		{
			var dmpExport:DMPExport=e.result as DMPExport;
			
			var qStatementId:String=dmpExport.qStatementId;
			var qStatement:String=dmpExport.qStatement;
			var response:String=dmpExport.response;
			var alertStatus:String=dmpExport.alertStatus;
			var freqQuestions:String=dmpExport.freqQuestions;
			var fbackEducation:String=dmpExport.fbackEducation;
			var lblGoto:String=dmpExport.lblGoto;
			var vendorInstr:String=dmpExport.vendorInstr;
			
			var dmpId:String=dmpExport.dmpId;
			var dmpName:String=dmpExport.dmpName;
			var dmpDesc:String=dmpExport.dmpDesc;
			var dmpObj:String=dmpExport.dmpObj;
			var dmpTag:String=dmpExport.dmpTag;
			var dmpContentId:String=dmpExport.dmpContentId;
			var dmpContentTypeId:String=dmpExport.dmpContentTypeId;
			
			var contentList:ArrayCollection=dmpExport.dmpComponentList;
			
			var dg:DataGrid=new DataGrid();
			var columns:Array=[];
			
			// Column 1 - QS Order
			var dgc:DataGridColumn=new DataGridColumn();
			dgc.headerText=qStatementId;
			try {
				dgc.dataField=getValueOrNA((contentList.getItemAt(0) as DMPContents).qStmtId);
			} catch (e:Error) {
				dgc.dataField="ERROR";
			}
			
			columns.push(dgc);
			
			// Column 2  QS Content
			var dgc1:DataGridColumn=new DataGridColumn();
			dgc1.headerText=qStatement;
			try {
				dgc1.dataField=getValueOrNA((contentList.getItemAt(1) as DMPContents).qStmtIdDesc);
			} catch (e:Error) {
				dgc1.dataField="ERROR";
			}
			columns.push(dgc1);
			
			// Column 3 Frequency
			var dgc2:DataGridColumn=new DataGridColumn();
			dgc2.headerText=freqQuestions;
			try {
				dgc2.dataField=getValueOrNA((contentList.getItemAt(2) as DMPContents).freqQuestion);
			} catch (e:Error) {
				dgc2.dataField="ERROR";
			}
			columns.push(dgc2);
			
			// Column 4  RESPONSE CONTENT
			var dgc3:DataGridColumn=new DataGridColumn();
			dgc3.headerText=response;
			try {
				dgc3.dataField=getValueOrNA((contentList.getItemAt(3) as DMPContents).response);
			} catch (e:Error) {
				dgc3.dataField="ERROR";
			}
			
			columns.push(dgc3);
			
			// Column 5 Alert Tyep Label
			var dgc4:DataGridColumn=new DataGridColumn();
			dgc4.headerText=alertStatus;
			try {
				dgc4.dataField=getValueOrNA((contentList.getItemAt(4) as DMPContents).alertStatus);
			} catch (e:Error) {
				dgc4.dataField="ERROR";
			}
			columns.push(dgc4);
			
			
			
			// Column 6 Response EC
			var dgc5:DataGridColumn=new DataGridColumn();
			dgc5.headerText=fbackEducation;
			try {
				dgc5.dataField=getValueOrNA((contentList.getItemAt(5) as DMPContents).feedbackEdu);
			} catch (e:Error) {
				dgc5.dataField="ERROR";
			}
			columns.push(dgc5);
			
			// Column 7 Response Next Question
			var dgc6:DataGridColumn=new DataGridColumn();
			dgc6.headerText=lblGoto;
			try {
				dgc6.dataField=getValueOrNA((contentList.getItemAt(6) as DMPContents).gotoValue);
			} catch (e:Error) {
				dgc6.dataField="ERROR";
			}
			columns.push(dgc6);
			
			// Column 8 Response Vendor Instr
			var dgc7:DataGridColumn=new DataGridColumn();
			dgc7.headerText=vendorInstr;
			try {
				dgc7.dataField=getValueOrNA((contentList.getItemAt(7) as DMPContents).vendorInst);
			} catch (e:Error) {
				dgc7.dataField="ERROR";
			}
			columns.push(dgc7);
			
			// Column 5 Frequency
			var dgc8:DataGridColumn=new DataGridColumn();
			dgc8.headerText=dmpContentTypeId;
			try {
				dgc8.dataField=getValueOrNA((contentList.getItemAt(14) as DMPContents).dmpContentTypeId);
			} catch (e:Error) {
				dgc4.dataField="ERROR";
			}
			columns.push(dgc8);
			
			
			dg.columns=columns;
			dg.dataProvider=contentList;
			dg.name = _dmpName;
			//fr.save(model.dataByteArray, _dmpName + "_DMP" + model.fileDate + ".xls");
			//Alert.show("Would you like to export this DMP?", "File Ready", Alert.YES | Alert.NO, FlexGlobals.topLevelApplication.parentDocument, saveSelectedFile);
			
			var excelGenerator:ExcelGenerator=ExcelGeneratorFactory.getDefaultGenerator();
			excelGenerator.getExcelSaveAs(dg);
			var model:SimpleExcelModel=SimpleExcelModel.getInstance();
			dmpController.invokeRemoteSimple("deployToVendor",[deployedDMP, selectedVendor,model.dataByteArray,_dmpName+"_DMP" +model.fileDate],deployToVendorHandler,myRO_faultHandler);
		}
		protected function deployToVendorHandler(e:ResultEvent):void 
		{				
			//dmpController.invokeRemoteSimple("deployToVendor",[model.dataByteArray,"_DMP" +model.fileDate,_dmpName],deployToVendorHandler,myRO_faultHandler);
			var success:Boolean=e.result as Boolean;
		}
	
		
		public function getGridColumn(header:String, data:String):DataGridColumn
		{
			var gridCol:DataGridColumn = new DataGridColumn();
			try 
			{
				gridCol.headerText = header;				
				gridCol.dataField = data;
			} 
			catch (e:Error) 
			{
				gridCol.dataField="ERROR";
			}
			
			return gridCol;
		}	
	}
}